/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.PropertyType;
import org.apache.olingo.commons.api.data.Valuable;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.core.edm.EdmTypeInfo;
import org.apache.olingo.server.api.deserializer.DeserializerException;

public class ODataJsonInstanceAnnotationDeserializer {
    private static final String ODATA_CONTROL_INFORMATION_PREFIX = "@odata.";

    public Annotation consumeInstanceAnnotation(String key, JsonNode value) throws DeserializerException {
        Annotation annotation = new Annotation();
        annotation.setTerm(key);
        try {
            this.value(annotation, value);
        }
        catch (IOException | EdmPrimitiveTypeException e) {
            throw new DeserializerException("Property: " + key, DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, key);
        }
        return annotation;
    }

    private void value(Valuable valuable, JsonNode node) throws IOException, EdmPrimitiveTypeException {
        EdmTypeInfo typeInfo = null;
        Map.Entry<PropertyType, EdmTypeInfo> guessed = this.guessPropertyType(node);
        if (typeInfo == null) {
            typeInfo = guessed.getValue();
        }
        PropertyType propType = typeInfo == null ? guessed.getKey() : (typeInfo.isCollection() ? PropertyType.COLLECTION : (typeInfo.isPrimitiveType() ? PropertyType.PRIMITIVE : (node.isValueNode() ? PropertyType.ENUM : PropertyType.COMPLEX)));
        switch (propType) {
            case COLLECTION: {
                this.fromCollection(valuable, node.elements(), typeInfo);
                break;
            }
            case COMPLEX: {
                Object value;
                if (node.has("@odata.type")) {
                    valuable.setType(node.get("@odata.type").asText());
                    ((ObjectNode)node).remove("@odata.type");
                }
                if ((value = this.fromComplex((ObjectNode)node)) instanceof ComplexValue) {
                    ((ComplexValue)value).setTypeName(valuable.getType());
                }
                valuable.setValue(ValueType.COMPLEX, value);
                break;
            }
            case ENUM: {
                if (node.isNull()) break;
                valuable.setValue(ValueType.ENUM, node.asText());
                break;
            }
            case PRIMITIVE: {
                Object primitiveValue;
                if (valuable.getType() == null && typeInfo != null) {
                    valuable.setType(typeInfo.getPrimitiveTypeKind().name());
                }
                valuable.setValue((primitiveValue = this.fromPrimitive(node, typeInfo)) instanceof Geospatial ? ValueType.GEOSPATIAL : ValueType.PRIMITIVE, primitiveValue);
                break;
            }
            default: {
                valuable.setValue(ValueType.PRIMITIVE, "");
            }
        }
    }

    private Object fromPrimitive(JsonNode node, EdmTypeInfo typeInfo) throws EdmPrimitiveTypeException {
        return node.isNull() ? null : (typeInfo == null ? node.asText() : ((EdmPrimitiveType)typeInfo.getType()).valueOfString(node.asText(), true, null, Constants.DEFAULT_PRECISION, Constants.DEFAULT_SCALE, true, ((EdmPrimitiveType)typeInfo.getType()).getDefaultType()));
    }

    private Object fromComplex(ObjectNode node) throws IOException, EdmPrimitiveTypeException {
        ComplexValue complexValue = new ComplexValue();
        HashSet<String> toRemove = new HashSet<String>();
        Iterator<Map.Entry<String, JsonNode>> itor = node.fields();
        while (itor.hasNext()) {
            Map.Entry<String, JsonNode> field = itor.next();
            if (field.getKey().contains(ODATA_CONTROL_INFORMATION_PREFIX)) {
                toRemove.add(field.getKey());
                continue;
            }
            Property property = new Property();
            property.setName(field.getKey());
            this.value(property, field.getValue());
            complexValue.getValue().add(property);
        }
        node.remove(toRemove);
        return complexValue;
    }

    private void fromCollection(Valuable valuable, Iterator<JsonNode> nodeItor, EdmTypeInfo typeInfo) throws IOException, EdmPrimitiveTypeException {
        EdmTypeInfo type;
        ArrayList<Object> values = new ArrayList<Object>();
        ValueType valueType = ValueType.COLLECTION_PRIMITIVE;
        EdmTypeInfo edmTypeInfo = type = typeInfo == null ? null : new EdmTypeInfo.Builder().setTypeExpression(typeInfo.getFullQualifiedName().toString()).build();
        while (nodeItor.hasNext()) {
            JsonNode child = nodeItor.next();
            if (child.isValueNode()) {
                if (typeInfo == null || typeInfo.isPrimitiveType()) {
                    Object value = this.fromPrimitive(child, type);
                    valueType = value instanceof Geospatial ? ValueType.COLLECTION_GEOSPATIAL : ValueType.COLLECTION_PRIMITIVE;
                    values.add(value);
                    continue;
                }
                valueType = ValueType.COLLECTION_ENUM;
                values.add(child.asText());
                continue;
            }
            if (!child.isContainerNode()) continue;
            EdmTypeInfo childType = null;
            if (child.has("@odata.type")) {
                String typeName = child.get("@odata.type").asText();
                childType = typeName == null ? null : new EdmTypeInfo.Builder().setTypeExpression(typeName).build();
                ((ObjectNode)child).remove("@odata.type");
            }
            Object value = this.fromComplex((ObjectNode)child);
            if (childType != null) {
                ((ComplexValue)value).setTypeName(childType.external());
            }
            valueType = ValueType.COLLECTION_COMPLEX;
            values.add(value);
        }
        valuable.setValue(valueType, values);
    }

    private Map.Entry<PropertyType, EdmTypeInfo> guessPropertyType(JsonNode node) {
        PropertyType type;
        String typeExpression = null;
        if (node.isValueNode() || node.isNull()) {
            type = PropertyType.PRIMITIVE;
            typeExpression = this.guessPrimitiveTypeKind(node).getFullQualifiedName().toString();
        } else if (node.isArray()) {
            type = PropertyType.COLLECTION;
            if (node.has(0) && node.get(0).isValueNode()) {
                typeExpression = "Collection(" + (Object)((Object)this.guessPrimitiveTypeKind(node.get(0))) + ')';
            }
        } else if (node.isObject()) {
            if (node.has("type")) {
                type = PropertyType.PRIMITIVE;
                typeExpression = "Edm.Geography" + node.get("type").asText();
            } else {
                type = PropertyType.COMPLEX;
            }
        } else {
            type = PropertyType.EMPTY;
        }
        EdmTypeInfo typeInfo = typeExpression == null ? null : new EdmTypeInfo.Builder().setTypeExpression(typeExpression).build();
        return new AbstractMap.SimpleEntry<PropertyType, EdmTypeInfo>(type, typeInfo);
    }

    private EdmPrimitiveTypeKind guessPrimitiveTypeKind(JsonNode node) {
        return node.isShort() ? EdmPrimitiveTypeKind.Int16 : (node.isInt() ? EdmPrimitiveTypeKind.Int32 : (node.isLong() ? EdmPrimitiveTypeKind.Int64 : (node.isBoolean() ? EdmPrimitiveTypeKind.Boolean : (node.isFloat() ? EdmPrimitiveTypeKind.Single : (node.isDouble() ? EdmPrimitiveTypeKind.Double : (node.isBigDecimal() ? EdmPrimitiveTypeKind.Decimal : EdmPrimitiveTypeKind.String))))));
    }
}

