/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.etag;

import org.apache.olingo.commons.api.edm.EdmBindingTarget;
import org.apache.olingo.commons.api.edm.EdmFunctionImport;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.server.api.etag.CustomETagSupport;
import org.apache.olingo.server.api.etag.PreconditionException;
import org.apache.olingo.server.api.uri.UriInfo;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceEntitySet;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourceSingleton;

public class PreconditionsValidator {
    private final EdmBindingTarget affectedEntitySetOrSingleton;

    public PreconditionsValidator(UriInfo uriInfo) throws PreconditionException {
        this.affectedEntitySetOrSingleton = this.extractInformation(uriInfo);
    }

    public boolean mustValidatePreconditions(CustomETagSupport customETagSupport, boolean isMediaValue) {
        return this.affectedEntitySetOrSingleton != null && (isMediaValue ? customETagSupport.hasMediaETag(this.affectedEntitySetOrSingleton) : customETagSupport.hasETag(this.affectedEntitySetOrSingleton));
    }

    private EdmBindingTarget extractInformation(UriInfo uriInfo) throws PreconditionException {
        EdmBindingTarget lastFoundEntitySetOrSingleton = null;
        int counter = 0;
        for (UriResource uriResourcePart : uriInfo.getUriResourceParts()) {
            switch (uriResourcePart.getKind()) {
                case function: {
                    lastFoundEntitySetOrSingleton = this.getEntitySetFromFunctionImport((UriResourceFunction)uriResourcePart);
                    break;
                }
                case singleton: {
                    lastFoundEntitySetOrSingleton = ((UriResourceSingleton)uriResourcePart).getSingleton();
                    break;
                }
                case entitySet: {
                    lastFoundEntitySetOrSingleton = this.getEntitySet((UriResourceEntitySet)uriResourcePart);
                    break;
                }
                case navigationProperty: {
                    lastFoundEntitySetOrSingleton = this.getEntitySetFromNavigation(lastFoundEntitySetOrSingleton, (UriResourceNavigation)uriResourcePart);
                    break;
                }
                case primitiveProperty: 
                case complexProperty: {
                    break;
                }
                case value: 
                case action: {
                    if (counter == uriInfo.getUriResourceParts().size() - 1) break;
                    throw new PreconditionException("$value or Action must be the last segment in the URI.", PreconditionException.MessageKeys.INVALID_URI, new String[0]);
                }
                default: {
                    lastFoundEntitySetOrSingleton = null;
                }
            }
            if (lastFoundEntitySetOrSingleton == null) break;
            ++counter;
        }
        return lastFoundEntitySetOrSingleton;
    }

    private EdmBindingTarget getEntitySetFromFunctionImport(UriResourceFunction uriResourceFunction) {
        EdmFunctionImport functionImport = uriResourceFunction.getFunctionImport();
        if (functionImport != null && functionImport.getReturnedEntitySet() != null && !uriResourceFunction.isCollection()) {
            return functionImport.getReturnedEntitySet();
        }
        return null;
    }

    private EdmBindingTarget getEntitySet(UriResourceEntitySet uriResourceEntitySet) {
        return uriResourceEntitySet.isCollection() ? null : uriResourceEntitySet.getEntitySet();
    }

    private EdmBindingTarget getEntitySetFromNavigation(EdmBindingTarget lastFoundEntitySetOrSingleton, UriResourceNavigation uriResourceNavigation) {
        if (lastFoundEntitySetOrSingleton != null && !uriResourceNavigation.isCollection()) {
            EdmNavigationProperty navProp = uriResourceNavigation.getProperty();
            return lastFoundEntitySetOrSingleton.getRelatedBindingTarget(navProp.getName());
        }
        return null;
    }
}

