/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.serializer.utils;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmFunction;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.core.Encoder;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.api.uri.UriParameter;
import org.apache.olingo.server.api.uri.UriResource;
import org.apache.olingo.server.api.uri.UriResourceAction;
import org.apache.olingo.server.api.uri.UriResourceComplexProperty;
import org.apache.olingo.server.api.uri.UriResourceFunction;
import org.apache.olingo.server.api.uri.UriResourceNavigation;
import org.apache.olingo.server.api.uri.UriResourceProperty;
import org.apache.olingo.server.api.uri.queryoption.ExpandItem;
import org.apache.olingo.server.api.uri.queryoption.ExpandOption;
import org.apache.olingo.server.api.uri.queryoption.SelectItem;
import org.apache.olingo.server.api.uri.queryoption.SelectOption;
import org.apache.olingo.server.core.serializer.utils.ExpandSelectHelper;

public final class ContextURLHelper {
    private ContextURLHelper() {
    }

    public static String buildSelectList(EdmStructuredType type, ExpandOption expand, SelectOption select) throws SerializerException {
        StringBuilder result = new StringBuilder();
        if (ExpandSelectHelper.hasSelect(select)) {
            ContextURLHelper.handleSelect(type, select, result);
        }
        if (ExpandSelectHelper.hasExpand(expand) && null == ExpandSelectHelper.getExpandAll(expand)) {
            ContextURLHelper.handleExpand(type, expand, result);
        } else if (expand != null && null != ExpandSelectHelper.getExpandAll(expand)) {
            ContextURLHelper.handleExpandAll(type, expand, result);
        }
        return result.length() == 0 ? null : result.toString();
    }

    private static void handleSelect(EdmStructuredType type, SelectOption select, StringBuilder result) {
        if (ExpandSelectHelper.isAll(select)) {
            result.append('*');
        } else {
            List<SelectItem> selectItems = select.getSelectItems();
            type = ContextURLHelper.getTypeFromSelectItems(selectItems, type);
            Set<String> selectedPropertyNames = ExpandSelectHelper.getSelectedPropertyNames(selectItems);
            for (String propertyName : type.getPropertyNames()) {
                ContextURLHelper.constructSelectItemList(type, result, selectItems, selectedPropertyNames, propertyName);
            }
            for (String propertyName : type.getNavigationPropertyNames()) {
                ContextURLHelper.constructSelectItemList(type, result, selectItems, selectedPropertyNames, propertyName);
            }
            ContextURLHelper.constructSelectItemListForActionsAndFunctions(type, result, selectItems);
        }
    }

    private static void constructSelectItemListForActionsAndFunctions(EdmStructuredType type, StringBuilder result, List<SelectItem> selectItems) {
        for (SelectItem item : selectItems) {
            EdmFunction function;
            UriResource resource = item.getResourcePath().getUriResourceParts().get(0);
            if (resource instanceof UriResourceAction) {
                EdmAction action = ((UriResourceAction)resource).getAction();
                if (action == null || !action.isBound()) continue;
                String actionBindingParamType = action.getBindingParameterTypeFqn().getFullQualifiedNameAsString();
                if (!type.getFullQualifiedName().getFullQualifiedNameAsString().equalsIgnoreCase(actionBindingParamType)) continue;
                if (result.length() > 0) {
                    result.append(',');
                }
                result.append(Encoder.encode(action.getFullQualifiedName().getFullQualifiedNameAsString()));
                continue;
            }
            if (!(resource instanceof UriResourceFunction) || (function = ((UriResourceFunction)resource).getFunction()) == null || !function.isBound()) continue;
            String functionBindingParamType = function.getBindingParameterTypeFqn().getFullQualifiedNameAsString();
            if (!type.getFullQualifiedName().getFullQualifiedNameAsString().equalsIgnoreCase(functionBindingParamType)) continue;
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(Encoder.encode(function.getFullQualifiedName().getFullQualifiedNameAsString()));
        }
    }

    private static EdmStructuredType getTypeFromSelectItems(List<SelectItem> selectItems, EdmStructuredType type) {
        EdmStructuredType edmType = type;
        for (SelectItem item : selectItems) {
            if (item.getStartTypeFilter() == null || !(item.getStartTypeFilter() instanceof EdmEntityType)) continue;
            edmType = (EdmEntityType)item.getStartTypeFilter();
        }
        return edmType;
    }

    private static void constructSelectItemList(EdmStructuredType type, StringBuilder result, List<SelectItem> selectItems, Set<String> selectedPropertyNames, String propertyName) {
        List<String> keyNames;
        if (selectedPropertyNames.contains(propertyName)) {
            if (result.length() > 0) {
                result.append(',');
            }
            EdmProperty edmProperty = type.getStructuralProperty(propertyName);
            Set<List<String>> selectedPaths = ExpandSelectHelper.getSelectedPathsWithTypeCasts(selectItems, propertyName);
            if (selectedPaths == null) {
                result.append(Encoder.encode(propertyName));
            } else {
                ArrayList<List<String>> complexSelectedPaths;
                List<List<String>> list = complexSelectedPaths = edmProperty != null && edmProperty.getType() instanceof EdmComplexType ? ContextURLHelper.getComplexSelectedPaths(edmProperty, selectedPaths) : new ArrayList<List<String>>();
                if (complexSelectedPaths.isEmpty()) {
                    for (List<String> path : selectedPaths) {
                        complexSelectedPaths.add(path);
                    }
                    int position = ContextURLHelper.getPositionToAddProperty(selectItems, propertyName, selectedPaths);
                    if (position == -1) {
                        ((List)complexSelectedPaths.get(0)).add(propertyName);
                    } else {
                        ((List)complexSelectedPaths.get(0)).add(position, propertyName);
                    }
                }
                boolean first = true;
                for (List list2 : complexSelectedPaths) {
                    if (first) {
                        first = false;
                    } else {
                        result.append(',');
                    }
                    boolean innerFirst = true;
                    for (String name : list2) {
                        if (innerFirst) {
                            innerFirst = false;
                        } else {
                            result.append('/');
                        }
                        result.append(Encoder.encode(name));
                    }
                }
            }
        } else if (type instanceof EdmEntityType && (keyNames = ((EdmEntityType)type).getKeyPredicateNames()).contains(propertyName)) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(Encoder.encode(propertyName));
        }
    }

    private static int getPositionToAddProperty(List<SelectItem> selectItems, String propertyName, Set<List<String>> selectedPaths) {
        for (SelectItem item : selectItems) {
            List<UriResource> parts = item.getResourcePath().getUriResourceParts();
            int i = 0;
            for (UriResource part : parts) {
                if (part instanceof UriResourceComplexProperty && ((UriResourceComplexProperty)part).getProperty().getName().equalsIgnoreCase(propertyName)) {
                    if (((UriResourceComplexProperty)part).getComplexTypeFilter() != null) {
                        return ContextURLHelper.getComplexPropertyPosition(selectedPaths, (UriResourceComplexProperty)part);
                    }
                    return i;
                }
                if (part instanceof UriResourceNavigation && ((UriResourceNavigation)part).getProperty().getName().equalsIgnoreCase(propertyName)) {
                    return -1;
                }
                ++i;
            }
        }
        return -1;
    }

    private static int getComplexPropertyPosition(Set<List<String>> selectedPaths, UriResourceComplexProperty part) {
        for (List<String> pathSel : selectedPaths) {
            int i = 0;
            for (String sel : pathSel) {
                if (sel.equalsIgnoreCase(part.getComplexTypeFilter().getFullQualifiedName().getFullQualifiedNameAsString())) {
                    return i;
                }
                ++i;
            }
        }
        return 0;
    }

    private static void handleExpand(EdmStructuredType type, ExpandOption expand, StringBuilder result) throws SerializerException {
        Set<String> expandedPropertyNames = ExpandSelectHelper.getExpandedPropertyNames(expand.getExpandItems());
        for (String propertyName : type.getNavigationPropertyNames()) {
            if (!expandedPropertyNames.contains(propertyName)) continue;
            ExpandItem expandItem = ExpandSelectHelper.getExpandItem(expand.getExpandItems(), propertyName);
            if (ExpandSelectHelper.hasExpand(expandItem.getExpandOption()) && null == ExpandSelectHelper.getExpandAll(expandItem.getExpandOption()) || ExpandSelectHelper.hasSelect(expandItem.getSelectOption())) {
                String innerSelectList = ContextURLHelper.buildSelectList(type.getNavigationProperty(propertyName).getType(), expandItem.getExpandOption(), expandItem.getSelectOption());
                if (innerSelectList == null) continue;
                if (result.length() > 0) {
                    result.append(',');
                }
                result.append(Encoder.encode(propertyName)).append('(').append(innerSelectList).append(')');
                continue;
            }
            List<UriResource> resourceParts = expandItem.getResourcePath().getUriResourceParts();
            if (resourceParts.size() > 1) {
                if (result.length() > 0) {
                    result.append(',');
                }
                List<String> path = ContextURLHelper.getPropertyPath(resourceParts);
                String propertyPath = ContextURLHelper.buildPropertyPath(path);
                result.append(Encoder.encode(propertyName));
                result.append("/").append(propertyPath);
                continue;
            }
            ContextURLHelper.appendExpandedProperty(result, propertyName);
        }
    }

    private static void handleExpandAll(EdmStructuredType type, ExpandOption expand, StringBuilder result) throws SerializerException {
        for (String propertyName : type.getNavigationPropertyNames()) {
            ContextURLHelper.appendExpandedProperty(result, propertyName);
        }
    }

    private static void appendExpandedProperty(StringBuilder result, String propertyName) throws SerializerException {
        if (result.length() > 0) {
            result.append(',');
        }
        result.append(Encoder.encode(propertyName) + "()");
    }

    private static List<String> getPropertyPath(List<UriResource> path) {
        LinkedList<String> result = new LinkedList<String>();
        for (int index = 1; index < path.size() && path.get(index) instanceof UriResourceProperty; ++index) {
            result.add(((UriResourceProperty)path.get(index)).getProperty().getName());
        }
        return result;
    }

    private static String buildPropertyPath(List<String> path) {
        StringBuilder result = new StringBuilder();
        for (String segment : path) {
            result.append(result.length() == 0 ? "" : Character.valueOf('/')).append(Encoder.encode(segment));
        }
        return result.length() == 0 ? null : result.toString();
    }

    private static List<List<String>> getComplexSelectedPaths(EdmProperty edmProperty, Set<List<String>> selectedPaths) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        if (selectedPaths == null) {
            LinkedList<String> path = new LinkedList<String>();
            path.add(edmProperty.getName());
            result.add(path);
        } else {
            List<List<String>> complexSelectedPaths;
            EdmComplexType type = (EdmComplexType)edmProperty.getType();
            for (String complexPropertyName : type.getPropertyNames()) {
                if (!ExpandSelectHelper.isSelected(selectedPaths, complexPropertyName)) continue;
                complexSelectedPaths = ContextURLHelper.getComplexSelectedPaths((EdmProperty)type.getProperty(complexPropertyName), ExpandSelectHelper.getReducedSelectedPaths(selectedPaths, complexPropertyName));
                for (List<String> path : complexSelectedPaths) {
                    path.add(0, edmProperty.getName());
                    result.add(path);
                }
            }
            for (String complexPropertyName : type.getNavigationPropertyNames()) {
                if (!ExpandSelectHelper.isSelected(selectedPaths, complexPropertyName)) continue;
                complexSelectedPaths = ContextURLHelper.getComplexSelectedPaths((EdmNavigationProperty)type.getProperty(complexPropertyName));
                for (List<String> path : complexSelectedPaths) {
                    path.add(0, edmProperty.getName());
                    result.add(path);
                }
            }
        }
        return result;
    }

    private static List<List<String>> getComplexSelectedPaths(EdmNavigationProperty edmProperty) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        LinkedList<String> path = new LinkedList<String>();
        path.add(edmProperty.getName());
        result.add(path);
        return result;
    }

    public static String buildKeyPredicate(List<UriParameter> keys) throws SerializerException {
        if (keys == null || keys.isEmpty()) {
            return null;
        }
        if (keys.size() == 1) {
            return Encoder.encode(keys.get(0).getText());
        }
        StringBuilder result = new StringBuilder();
        for (UriParameter key : keys) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(Encoder.encode(key.getName())).append('=').append(Encoder.encode(key.getText()));
        }
        return result.toString();
    }
}

