/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.openapi.RestApiResponseAdapter;

public class DefaultRestApiResponseAdapter
implements RestApiResponseAdapter {
    private final Map<String, String> headers = new LinkedHashMap<String, String>();
    private byte[] body;
    private boolean noContent;
    private OpenAPI openApi;

    @Override
    public OpenAPI getOpenApi() {
        return this.openApi;
    }

    @Override
    public void setOpenApi(OpenAPI openApi) {
        this.openApi = openApi;
    }

    @Override
    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public void writeBytes(byte[] bytes) throws IOException {
        this.body = bytes;
    }

    @Override
    public void noContent() {
        this.noContent = true;
    }

    @Override
    public void copyResult(Exchange exchange) {
        if (!this.headers.isEmpty()) {
            exchange.getMessage().getHeaders().putAll(this.headers);
        }
        if (this.body != null) {
            exchange.getMessage().setBody(this.body);
        }
        if (this.noContent) {
            exchange.getMessage().setHeader("CamelHttpResponseCode", 204);
        }
    }
}

