/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Schema;
import org.apache.camel.util.FileUtil;

public final class OpenApiHelper {
    private OpenApiHelper() {
    }

    public static String buildUrl(String path1, String path2) {
        String s1 = FileUtil.stripTrailingSeparator(path1);
        String s2 = FileUtil.stripLeadingSeparator(path2);
        Object answer = s1 != null && s2 != null ? s1 + "/" + s2 : (path1 != null ? path1 : path2);
        if (answer != null && !((String)answer).startsWith("/")) {
            answer = "/" + (String)answer;
        }
        return answer;
    }

    public static void clearVendorExtensions(OpenAPI openApi) {
        if (openApi.getExtensions() != null) {
            openApi.getExtensions().clear();
        }
        if (openApi.getComponents() != null && openApi.getComponents().getSchemas() != null) {
            for (Schema schemaDefinition : openApi.getComponents().getSchemas().values()) {
                if (schemaDefinition.getExtensions() == null) continue;
                schemaDefinition.getExtensions().clear();
            }
        }
        if (openApi.getPaths() != null) {
            for (PathItem path : openApi.getPaths().values()) {
                if (path.getExtensions() != null) {
                    path.getExtensions().clear();
                }
                for (Operation op : path.readOperationsMap().values()) {
                    if (op.getExtensions() == null) continue;
                    op.getExtensions().clear();
                }
            }
        }
    }
}

