/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.openapi;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.converter.ModelConverters;
import io.swagger.v3.core.jackson.ModelResolver;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RestModelConverters {
    private static final ModelConverters MODEL31_CONVERTERS = ModelConverters.getInstance(true);
    private static final ModelConverters MODEL30_CONVERTERS;
    private static final ModelConverters MODEL20_CONVERTERS;
    private final boolean openapi31;

    public RestModelConverters(boolean openapi31) {
        this.openapi31 = openapi31;
    }

    public List<? extends Schema<?>> readClass(OpenAPI oasDocument, Class<?> clazz) {
        if (clazz.equals(File.class)) {
            return null;
        }
        return this.readClassOpenApi3(clazz);
    }

    private List<? extends Schema<?>> readClassOpenApi3(Class<?> clazz) {
        String name = clazz.getName();
        if (!name.contains(".")) {
            return null;
        }
        ModelConverters modelConverters = this.openapi31 ? MODEL31_CONVERTERS : MODEL30_CONVERTERS;
        Map<String, Schema> swaggerModel = modelConverters.readAll(clazz);
        ArrayList modelSchemas = new ArrayList();
        swaggerModel.forEach((key, schema) -> {
            schema.setName((String)key);
            modelSchemas.add(schema);
        });
        return modelSchemas;
    }

    static {
        MODEL31_CONVERTERS.addConverter(new ClassNameExtensionModelResolver(new FqnModelResolver(true)));
        MODEL30_CONVERTERS = ModelConverters.getInstance();
        MODEL30_CONVERTERS.addConverter(new ClassNameExtensionModelResolver(new FqnModelResolver()));
        MODEL20_CONVERTERS = ModelConverters.getInstance();
        MODEL20_CONVERTERS.addConverter(new ClassNameExtensionModelResolver());
    }

    private static class ClassNameExtensionModelResolver
    extends ModelResolver {
        private final ModelResolver delegate;

        public ClassNameExtensionModelResolver() {
            this(new ModelResolver(new ObjectMapper()));
            ModelResolver.composedModelPropertiesAsSibling = true;
        }

        public ClassNameExtensionModelResolver(ModelResolver delegate) {
            super(delegate.objectMapper());
            this.delegate = delegate;
        }

        @Override
        public Schema resolve(AnnotatedType annotatedType, ModelConverterContext context, Iterator<ModelConverter> next) {
            JavaType type;
            Schema result = this.delegate.resolve(annotatedType, context, next);
            if (result != null && Objects.equals("object", result.getType()) && !(type = annotatedType.getType() instanceof JavaType ? (JavaType)annotatedType.getType() : this._mapper.constructType(annotatedType.getType())).isContainerType()) {
                HashMap<String, String> value = new HashMap<String, String>();
                value.put("type", "string");
                value.put("format", type.getRawClass().getName());
                result.addExtension("x-className", value);
            }
            return result;
        }
    }

    private static class FqnModelResolver
    extends ModelResolver {
        public FqnModelResolver() {
            this(false);
        }

        public FqnModelResolver(boolean openapi31) {
            this(new ObjectMapper());
            this.openapi31(openapi31);
        }

        public FqnModelResolver(ObjectMapper mapper) {
            super(mapper);
            this._typeNameResolver.setUseFqn(true);
        }
    }
}

