/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tooling.util;

import java.util.Collection;

public final class Strings {
    private Strings() {
    }

    public static boolean isEmpty(String s) {
        return s == null || s.isBlank();
    }

    public static boolean isNullOrEmpty(String text) {
        return text == null || text.isEmpty() || "null".equals(text);
    }

    public static String safeNull(String text) {
        if (Strings.isNullOrEmpty(text)) {
            return "";
        }
        return text;
    }

    public static String getOrElse(String text, String defaultValue) {
        return text != null ? text : defaultValue;
    }

    public static String after(String text, String after) {
        if (text == null) {
            return null;
        }
        int pos = text.indexOf(after);
        if (pos == -1) {
            return null;
        }
        return text.substring(pos + after.length());
    }

    public static String after(String text, String after, String defaultValue) {
        String answer = Strings.after(text, after);
        return answer != null ? answer : defaultValue;
    }

    public static String canonicalClassName(String className) {
        int pos = className.indexOf(60);
        if (pos != -1) {
            className = className.substring(0, pos);
        }
        return className.replace('$', '.');
    }

    public static String doubleQuote(String text) {
        return Strings.quote(text, "\"");
    }

    public static String singleQuote(String text) {
        return Strings.quote(text, "'");
    }

    public static String quote(String text, String quote) {
        return quote + text + quote;
    }

    public static String between(String text, String after, String before) {
        if ((text = Strings.after(text, after)) == null) {
            return null;
        }
        return Strings.before(text, before);
    }

    public static String asTitle(String name) {
        StringBuilder sb = new StringBuilder(name.length() + 16);
        for (char c : name.toCharArray()) {
            boolean upper = Character.isUpperCase(c);
            boolean first = sb.isEmpty();
            if (first) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            if (upper) {
                char prev = sb.charAt(sb.length() - 1);
                if (!Character.isUpperCase(prev)) {
                    sb.append(' ');
                }
                sb.append(c);
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString().trim();
    }

    public static String before(String text, String before) {
        if (text == null) {
            return null;
        }
        int pos = text.indexOf(before);
        return pos == -1 ? null : text.substring(0, pos);
    }

    public static String indentCollection(String indent, Collection<String> list) {
        StringBuilder sb = new StringBuilder(256);
        for (String text : list) {
            sb.append(indent).append(text);
        }
        return sb.toString();
    }

    public static String camelDashToTitle(String value) {
        StringBuilder sb = new StringBuilder(value.length());
        boolean dash = false;
        for (char c : value.toCharArray()) {
            if ('-' == c) {
                dash = true;
                continue;
            }
            if (dash) {
                sb.append(' ');
                sb.append(Character.toUpperCase(c));
            } else if (sb.isEmpty()) {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(c);
            }
            dash = false;
        }
        return sb.toString();
    }

    public static String camelCaseToDash(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        char prev = '\u0000';
        char[] arr = text.toCharArray();
        StringBuilder answer = new StringBuilder(arr.length < 13 ? 16 : arr.length + 8);
        for (int i = 0; i < arr.length; ++i) {
            char ch = arr[i];
            if (ch == '-' || ch == '_') {
                answer.append("-");
            } else if (Character.isUpperCase(ch) && prev != '\u0000') {
                char next = i < arr.length - 1 ? arr[i + 1] : (char)'\u0000';
                if (!Character.isUpperCase(prev) || next != '\u0000' && Character.isLowerCase(next)) {
                    Strings.applyDashPrefix(prev, answer, ch);
                } else {
                    answer.append(Character.toLowerCase(ch));
                }
            } else {
                answer.append(Character.toLowerCase(ch));
            }
            prev = ch;
        }
        return answer.toString();
    }

    private static void applyDashPrefix(char prev, StringBuilder answer, char ch) {
        if (prev != '-' && prev != '_') {
            answer.append("-");
        }
        answer.append(Character.toLowerCase(ch));
    }

    public static String capitalize(String text) {
        return Strings.doCapitalize(text);
    }

    private static String doCapitalize(String ret) {
        if (ret == null) {
            return null;
        }
        char[] chars = ret.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }
}

