/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ScriptField
implements PlainJsonSerializable {
    private final Script script;
    @Nullable
    private final Boolean ignoreFailure;
    public static final JsonpDeserializer<ScriptField> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptField::setupScriptFieldDeserializer);

    private ScriptField(Builder builder) {
        this.script = ApiTypeHelper.requireNonNull(builder.script, this, "script");
        this.ignoreFailure = builder.ignoreFailure;
    }

    public static ScriptField of(Function<Builder, ObjectBuilder<ScriptField>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Script script() {
        return this.script;
    }

    @Nullable
    public final Boolean ignoreFailure() {
        return this.ignoreFailure;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("script");
        this.script.serialize(generator, mapper);
        if (this.ignoreFailure != null) {
            generator.writeKey("ignore_failure");
            generator.write(this.ignoreFailure);
        }
    }

    protected static void setupScriptFieldDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::script, Script._DESERIALIZER, "script");
        op.add(Builder::ignoreFailure, JsonpDeserializer.booleanDeserializer(), "ignore_failure");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ScriptField> {
        private Script script;
        @Nullable
        private Boolean ignoreFailure;

        public final Builder script(Script value) {
            this.script = value;
            return this;
        }

        public final Builder script(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.script(fn.apply(new Script.Builder()).build());
        }

        public final Builder ignoreFailure(@Nullable Boolean value) {
            this.ignoreFailure = value;
            return this;
        }

        @Override
        public ScriptField build() {
            this._checkSingleUse();
            return new ScriptField(this);
        }
    }
}

