/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationBase;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.GapPolicy;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class BucketSortAggregation
extends AggregationBase
implements AggregationVariant {
    @Nullable
    private final Integer from;
    @Nullable
    private final GapPolicy gapPolicy;
    @Nullable
    private final Integer size;
    private final List<SortOptions> sort;
    public static final JsonpDeserializer<BucketSortAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BucketSortAggregation::setupBucketSortAggregationDeserializer);

    private BucketSortAggregation(Builder builder) {
        super(builder);
        this.from = builder.from;
        this.gapPolicy = builder.gapPolicy;
        this.size = builder.size;
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
    }

    public static BucketSortAggregation of(Function<Builder, ObjectBuilder<BucketSortAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.BucketSort;
    }

    @Nullable
    public final Integer from() {
        return this.from;
    }

    @Nullable
    public final GapPolicy gapPolicy() {
        return this.gapPolicy;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    public final List<SortOptions> sort() {
        return this.sort;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.from != null) {
            generator.writeKey("from");
            generator.write(this.from);
        }
        if (this.gapPolicy != null) {
            generator.writeKey("gap_policy");
            this.gapPolicy.serialize(generator, mapper);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("sort");
            generator.writeStartArray();
            for (SortOptions item0 : this.sort) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupBucketSortAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BucketSortAggregation.setupAggregationBaseDeserializer(op);
        op.add(Builder::from, JsonpDeserializer.integerDeserializer(), "from");
        op.add(Builder::gapPolicy, GapPolicy._DESERIALIZER, "gap_policy");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(SortOptions._DESERIALIZER), "sort");
    }

    public static class Builder
    extends AggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BucketSortAggregation> {
        @Nullable
        private Integer from;
        @Nullable
        private GapPolicy gapPolicy;
        @Nullable
        private Integer size;
        @Nullable
        private List<SortOptions> sort;

        public final Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public final Builder gapPolicy(@Nullable GapPolicy value) {
            this.gapPolicy = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder sort(List<SortOptions> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(SortOptions value, SortOptions ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(Function<SortOptions.Builder, ObjectBuilder<SortOptions>> fn) {
            return this.sort(fn.apply(new SortOptions.Builder()).build(), new SortOptions[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BucketSortAggregation build() {
            this._checkSingleUse();
            return new BucketSortAggregation(this);
        }
    }
}

