/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class MatrixStatsFields
implements PlainJsonSerializable {
    private final String name;
    private final long count;
    private final double mean;
    private final double variance;
    private final double skewness;
    private final double kurtosis;
    private final Map<String, Double> covariance;
    private final Map<String, Double> correlation;
    public static final JsonpDeserializer<MatrixStatsFields> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MatrixStatsFields::setupMatrixStatsFieldsDeserializer);

    private MatrixStatsFields(Builder builder) {
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.count = ApiTypeHelper.requireNonNull(builder.count, this, "count");
        this.mean = ApiTypeHelper.requireNonNull(builder.mean, this, "mean");
        this.variance = ApiTypeHelper.requireNonNull(builder.variance, this, "variance");
        this.skewness = ApiTypeHelper.requireNonNull(builder.skewness, this, "skewness");
        this.kurtosis = ApiTypeHelper.requireNonNull(builder.kurtosis, this, "kurtosis");
        this.covariance = ApiTypeHelper.unmodifiableRequired(builder.covariance, (Object)this, "covariance");
        this.correlation = ApiTypeHelper.unmodifiableRequired(builder.correlation, (Object)this, "correlation");
    }

    public static MatrixStatsFields of(Function<Builder, ObjectBuilder<MatrixStatsFields>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String name() {
        return this.name;
    }

    public final long count() {
        return this.count;
    }

    public final double mean() {
        return this.mean;
    }

    public final double variance() {
        return this.variance;
    }

    public final double skewness() {
        return this.skewness;
    }

    public final double kurtosis() {
        return this.kurtosis;
    }

    public final Map<String, Double> covariance() {
        return this.covariance;
    }

    public final Map<String, Double> correlation() {
        return this.correlation;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("mean");
        generator.write(this.mean);
        generator.writeKey("variance");
        generator.write(this.variance);
        generator.writeKey("skewness");
        generator.write(this.skewness);
        generator.writeKey("kurtosis");
        generator.write(this.kurtosis);
        if (ApiTypeHelper.isDefined(this.covariance)) {
            generator.writeKey("covariance");
            generator.writeStartObject();
            for (Map.Entry<String, Double> item0 : this.covariance.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.correlation)) {
            generator.writeKey("correlation");
            generator.writeStartObject();
            for (Map.Entry<String, Double> item0 : this.correlation.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue());
            }
            generator.writeEnd();
        }
    }

    protected static void setupMatrixStatsFieldsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::mean, JsonpDeserializer.doubleDeserializer(), "mean");
        op.add(Builder::variance, JsonpDeserializer.doubleDeserializer(), "variance");
        op.add(Builder::skewness, JsonpDeserializer.doubleDeserializer(), "skewness");
        op.add(Builder::kurtosis, JsonpDeserializer.doubleDeserializer(), "kurtosis");
        op.add(Builder::covariance, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "covariance");
        op.add(Builder::correlation, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "correlation");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<MatrixStatsFields> {
        private String name;
        private Long count;
        private Double mean;
        private Double variance;
        private Double skewness;
        private Double kurtosis;
        private Map<String, Double> covariance;
        private Map<String, Double> correlation;

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder mean(double value) {
            this.mean = value;
            return this;
        }

        public final Builder variance(double value) {
            this.variance = value;
            return this;
        }

        public final Builder skewness(double value) {
            this.skewness = value;
            return this;
        }

        public final Builder kurtosis(double value) {
            this.kurtosis = value;
            return this;
        }

        public final Builder covariance(Map<String, Double> map) {
            this.covariance = Builder._mapPutAll(this.covariance, map);
            return this;
        }

        public final Builder covariance(String key, Double value) {
            this.covariance = Builder._mapPut(this.covariance, key, value);
            return this;
        }

        public final Builder correlation(Map<String, Double> map) {
            this.correlation = Builder._mapPutAll(this.correlation, map);
            return this;
        }

        public final Builder correlation(String key, Double value) {
            this.correlation = Builder._mapPut(this.correlation, key, value);
            return this;
        }

        @Override
        public MatrixStatsFields build() {
            this._checkSingleUse();
            return new MatrixStatsFields(this);
        }
    }
}

