/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.PipelineAggregationBase;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class MovingFunctionAggregation
extends PipelineAggregationBase
implements AggregationVariant {
    @Nullable
    private final String script;
    @Nullable
    private final Integer shift;
    @Nullable
    private final Integer window;
    public static final JsonpDeserializer<MovingFunctionAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MovingFunctionAggregation::setupMovingFunctionAggregationDeserializer);

    private MovingFunctionAggregation(Builder builder) {
        super(builder);
        this.script = builder.script;
        this.shift = builder.shift;
        this.window = builder.window;
    }

    public static MovingFunctionAggregation of(Function<Builder, ObjectBuilder<MovingFunctionAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.MovingFn;
    }

    @Nullable
    public final String script() {
        return this.script;
    }

    @Nullable
    public final Integer shift() {
        return this.shift;
    }

    @Nullable
    public final Integer window() {
        return this.window;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.script != null) {
            generator.writeKey("script");
            generator.write(this.script);
        }
        if (this.shift != null) {
            generator.writeKey("shift");
            generator.write(this.shift);
        }
        if (this.window != null) {
            generator.writeKey("window");
            generator.write(this.window);
        }
    }

    protected static void setupMovingFunctionAggregationDeserializer(ObjectDeserializer<Builder> op) {
        PipelineAggregationBase.setupPipelineAggregationBaseDeserializer(op);
        op.add(Builder::script, JsonpDeserializer.stringDeserializer(), "script");
        op.add(Builder::shift, JsonpDeserializer.integerDeserializer(), "shift");
        op.add(Builder::window, JsonpDeserializer.integerDeserializer(), "window");
    }

    public static class Builder
    extends PipelineAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<MovingFunctionAggregation> {
        @Nullable
        private String script;
        @Nullable
        private Integer shift;
        @Nullable
        private Integer window;

        public final Builder script(@Nullable String value) {
            this.script = value;
            return this;
        }

        public final Builder shift(@Nullable Integer value) {
            this.shift = value;
            return this;
        }

        public final Builder window(@Nullable Integer value) {
            this.window = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MovingFunctionAggregation build() {
            this._checkSingleUse();
            return new MovingFunctionAggregation(this);
        }
    }
}

