/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class UniqueTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final Boolean onlyOnSamePosition;
    public static final JsonpDeserializer<UniqueTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UniqueTokenFilter::setupUniqueTokenFilterDeserializer);

    private UniqueTokenFilter(Builder builder) {
        super(builder);
        this.onlyOnSamePosition = builder.onlyOnSamePosition;
    }

    public static UniqueTokenFilter of(Function<Builder, ObjectBuilder<UniqueTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Unique;
    }

    @Nullable
    public final Boolean onlyOnSamePosition() {
        return this.onlyOnSamePosition;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "unique");
        super.serializeInternal(generator, mapper);
        if (this.onlyOnSamePosition != null) {
            generator.writeKey("only_on_same_position");
            generator.write(this.onlyOnSamePosition);
        }
    }

    protected static void setupUniqueTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        UniqueTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::onlyOnSamePosition, JsonpDeserializer.booleanDeserializer(), "only_on_same_position");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<UniqueTokenFilter> {
        @Nullable
        private Boolean onlyOnSamePosition;

        public final Builder onlyOnSamePosition(@Nullable Boolean value) {
            this.onlyOnSamePosition = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public UniqueTokenFilter build() {
            this._checkSingleUse();
            return new UniqueTokenFilter(this);
        }
    }
}

