/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.opensearch._types.mapping.StandardNumberProperty;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class IntegerNumberProperty
extends StandardNumberProperty
implements PropertyVariant {
    @Nullable
    private final Integer nullValue;
    public static final JsonpDeserializer<IntegerNumberProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IntegerNumberProperty::setupIntegerNumberPropertyDeserializer);

    private IntegerNumberProperty(Builder builder) {
        super(builder);
        this.nullValue = builder.nullValue;
    }

    public static IntegerNumberProperty of(Function<Builder, ObjectBuilder<IntegerNumberProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Integer;
    }

    @Nullable
    public final Integer nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "integer");
        super.serializeInternal(generator, mapper);
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
    }

    protected static void setupIntegerNumberPropertyDeserializer(ObjectDeserializer<Builder> op) {
        StandardNumberProperty.setupStandardNumberPropertyDeserializer(op);
        op.add(Builder::nullValue, JsonpDeserializer.integerDeserializer(), "null_value");
        op.ignore("type");
    }

    public static class Builder
    extends StandardNumberProperty.AbstractBuilder<Builder>
    implements ObjectBuilder<IntegerNumberProperty> {
        @Nullable
        private Integer nullValue;

        public final Builder nullValue(@Nullable Integer value) {
            this.nullValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public IntegerNumberProperty build() {
            this._checkSingleUse();
            return new IntegerNumberProperty(this);
        }
    }
}

