/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.opensearch._types.query_dsl.SpanQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanQueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class SpanNearQuery
extends QueryBase
implements SpanQueryVariant,
QueryVariant {
    private final List<SpanQuery> clauses;
    @Nullable
    private final Boolean inOrder;
    @Nullable
    private final Integer slop;
    public static final JsonpDeserializer<SpanNearQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanNearQuery::setupSpanNearQueryDeserializer);

    private SpanNearQuery(Builder builder) {
        super(builder);
        this.clauses = ApiTypeHelper.unmodifiableRequired(builder.clauses, (Object)this, "clauses");
        this.inOrder = builder.inOrder;
        this.slop = builder.slop;
    }

    public static SpanNearQuery of(Function<Builder, ObjectBuilder<SpanNearQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SpanQuery.Kind _spanQueryKind() {
        return SpanQuery.Kind.SpanNear;
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.SpanNear;
    }

    public final List<SpanQuery> clauses() {
        return this.clauses;
    }

    @Nullable
    public final Boolean inOrder() {
        return this.inOrder;
    }

    @Nullable
    public final Integer slop() {
        return this.slop;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.clauses)) {
            generator.writeKey("clauses");
            generator.writeStartArray();
            for (SpanQuery item0 : this.clauses) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.inOrder != null) {
            generator.writeKey("in_order");
            generator.write(this.inOrder);
        }
        if (this.slop != null) {
            generator.writeKey("slop");
            generator.write(this.slop);
        }
    }

    public Builder toBuilder() {
        return new Builder().clauses(this.clauses).inOrder(this.inOrder).slop(this.slop);
    }

    protected static void setupSpanNearQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::clauses, JsonpDeserializer.arrayDeserializer(SpanQuery._DESERIALIZER), "clauses");
        op.add(Builder::inOrder, JsonpDeserializer.booleanDeserializer(), "in_order");
        op.add(Builder::slop, JsonpDeserializer.integerDeserializer(), "slop");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SpanNearQuery> {
        private List<SpanQuery> clauses;
        @Nullable
        private Boolean inOrder;
        @Nullable
        private Integer slop;

        public final Builder clauses(List<SpanQuery> list) {
            this.clauses = Builder._listAddAll(this.clauses, list);
            return this;
        }

        public final Builder clauses(SpanQuery value, SpanQuery ... values) {
            this.clauses = Builder._listAdd(this.clauses, value, values);
            return this;
        }

        public final Builder clauses(Function<SpanQuery.Builder, ObjectBuilder<SpanQuery>> fn) {
            return this.clauses(fn.apply(new SpanQuery.Builder()).build(), new SpanQuery[0]);
        }

        public final Builder inOrder(@Nullable Boolean value) {
            this.inOrder = value;
            return this;
        }

        public final Builder slop(@Nullable Integer value) {
            this.slop = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SpanNearQuery build() {
            this._checkSingleUse();
            return new SpanNearQuery(this);
        }
    }
}

