/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core;

import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.RequestBase;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.TermsEnumResponse;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.endpoints.SimpleEndpoint;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class TermsEnumRequest
extends RequestBase
implements PlainJsonSerializable {
    @Nullable
    private final Boolean caseInsensitive;
    private final String field;
    private final String index;
    @Nullable
    private final Query indexFilter;
    @Nullable
    private final String searchAfter;
    @Nullable
    private final Integer size;
    @Nullable
    private final String string;
    @Nullable
    private final Time timeout;
    public static final JsonpDeserializer<TermsEnumRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TermsEnumRequest::setupTermsEnumRequestDeserializer);
    public static final Endpoint<TermsEnumRequest, TermsEnumResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<TermsEnumRequest, TermsEnumResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index, buf);
            buf.append("/_terms_enum");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, TermsEnumResponse._DESERIALIZER);

    private TermsEnumRequest(Builder builder) {
        this.caseInsensitive = builder.caseInsensitive;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.index = ApiTypeHelper.requireNonNull(builder.index, this, "index");
        this.indexFilter = builder.indexFilter;
        this.searchAfter = builder.searchAfter;
        this.size = builder.size;
        this.string = builder.string;
        this.timeout = builder.timeout;
    }

    public static TermsEnumRequest of(Function<Builder, ObjectBuilder<TermsEnumRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    public final String field() {
        return this.field;
    }

    public final String index() {
        return this.index;
    }

    @Nullable
    public final Query indexFilter() {
        return this.indexFilter;
    }

    @Nullable
    public final String searchAfter() {
        return this.searchAfter;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final String string() {
        return this.string;
    }

    @Nullable
    public final Time timeout() {
        return this.timeout;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.caseInsensitive != null) {
            generator.writeKey("case_insensitive");
            generator.write(this.caseInsensitive);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.indexFilter != null) {
            generator.writeKey("index_filter");
            this.indexFilter.serialize(generator, mapper);
        }
        if (this.searchAfter != null) {
            generator.writeKey("search_after");
            generator.write(this.searchAfter);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        if (this.string != null) {
            generator.writeKey("string");
            generator.write(this.string);
        }
        if (this.timeout != null) {
            generator.writeKey("timeout");
            this.timeout.serialize(generator, mapper);
        }
    }

    public Builder toBuilder() {
        return new Builder().caseInsensitive(this.caseInsensitive).field(this.field).index(this.index).indexFilter(this.indexFilter).searchAfter(this.searchAfter).size(this.size).string(this.string).timeout(this.timeout);
    }

    protected static void setupTermsEnumRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::caseInsensitive, JsonpDeserializer.booleanDeserializer(), "case_insensitive");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::indexFilter, Query._DESERIALIZER, "index_filter");
        op.add(Builder::searchAfter, JsonpDeserializer.stringDeserializer(), "search_after");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::string, JsonpDeserializer.stringDeserializer(), "string");
        op.add(Builder::timeout, Time._DESERIALIZER, "timeout");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TermsEnumRequest> {
        @Nullable
        private Boolean caseInsensitive;
        private String field;
        private String index;
        @Nullable
        private Query indexFilter;
        @Nullable
        private String searchAfter;
        @Nullable
        private Integer size;
        @Nullable
        private String string;
        @Nullable
        private Time timeout;

        public final Builder caseInsensitive(@Nullable Boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder index(String value) {
            this.index = value;
            return this;
        }

        public final Builder indexFilter(@Nullable Query value) {
            this.indexFilter = value;
            return this;
        }

        public final Builder indexFilter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.indexFilter(fn.apply(new Query.Builder()).build());
        }

        public final Builder searchAfter(@Nullable String value) {
            this.searchAfter = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder string(@Nullable String value) {
            this.string = value;
            return this;
        }

        public final Builder timeout(@Nullable Time value) {
            this.timeout = value;
            return this;
        }

        public final Builder timeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.timeout(fn.apply(new Time.Builder()).build());
        }

        @Override
        public TermsEnumRequest build() {
            this._checkSingleUse();
            return new TermsEnumRequest(this);
        }
    }
}

