/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.explain;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.explain.ExplanationDetail;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class Explanation
implements PlainJsonSerializable {
    private final String description;
    private final List<ExplanationDetail> details;
    private final float value;
    public static final JsonpDeserializer<Explanation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Explanation::setupExplanationDeserializer);

    private Explanation(Builder builder) {
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.details = ApiTypeHelper.unmodifiableRequired(builder.details, (Object)this, "details");
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value").floatValue();
    }

    public static Explanation of(Function<Builder, ObjectBuilder<Explanation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String description() {
        return this.description;
    }

    public final List<ExplanationDetail> details() {
        return this.details;
    }

    public final float value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("description");
        generator.write(this.description);
        if (ApiTypeHelper.isDefined(this.details)) {
            generator.writeKey("details");
            generator.writeStartArray();
            for (ExplanationDetail item0 : this.details) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("value");
        generator.write(this.value);
    }

    protected static void setupExplanationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::details, JsonpDeserializer.arrayDeserializer(ExplanationDetail._DESERIALIZER), "details");
        op.add(Builder::value, JsonpDeserializer.floatDeserializer(), "value");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Explanation> {
        private String description;
        private List<ExplanationDetail> details;
        private Float value;

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder details(List<ExplanationDetail> list) {
            this.details = Builder._listAddAll(this.details, list);
            return this;
        }

        public final Builder details(ExplanationDetail value, ExplanationDetail ... values) {
            this.details = Builder._listAdd(this.details, value, values);
            return this;
        }

        public final Builder details(Function<ExplanationDetail.Builder, ObjectBuilder<ExplanationDetail>> fn) {
            return this.details(fn.apply(new ExplanationDetail.Builder()).build(), new ExplanationDetail[0]);
        }

        public final Builder value(float value) {
            this.value = Float.valueOf(value);
            return this;
        }

        @Override
        public Explanation build() {
            this._checkSingleUse();
            return new Explanation(this);
        }
    }
}

