/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.reindex_rethrottle;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.Retries;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ReindexStatus
implements PlainJsonSerializable {
    private final long batches;
    private final long created;
    private final long deleted;
    private final long noops;
    private final float requestsPerSecond;
    private final Retries retries;
    private final long throttledMillis;
    private final long throttledUntilMillis;
    private final long total;
    private final long updated;
    private final long versionConflicts;
    public static final JsonpDeserializer<ReindexStatus> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ReindexStatus::setupReindexStatusDeserializer);

    private ReindexStatus(Builder builder) {
        this.batches = ApiTypeHelper.requireNonNull(builder.batches, this, "batches");
        this.created = ApiTypeHelper.requireNonNull(builder.created, this, "created");
        this.deleted = ApiTypeHelper.requireNonNull(builder.deleted, this, "deleted");
        this.noops = ApiTypeHelper.requireNonNull(builder.noops, this, "noops");
        this.requestsPerSecond = ApiTypeHelper.requireNonNull(builder.requestsPerSecond, this, "requestsPerSecond").floatValue();
        this.retries = ApiTypeHelper.requireNonNull(builder.retries, this, "retries");
        this.throttledMillis = ApiTypeHelper.requireNonNull(builder.throttledMillis, this, "throttledMillis");
        this.throttledUntilMillis = ApiTypeHelper.requireNonNull(builder.throttledUntilMillis, this, "throttledUntilMillis");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
        this.updated = ApiTypeHelper.requireNonNull(builder.updated, this, "updated");
        this.versionConflicts = ApiTypeHelper.requireNonNull(builder.versionConflicts, this, "versionConflicts");
    }

    public static ReindexStatus of(Function<Builder, ObjectBuilder<ReindexStatus>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long batches() {
        return this.batches;
    }

    public final long created() {
        return this.created;
    }

    public final long deleted() {
        return this.deleted;
    }

    public final long noops() {
        return this.noops;
    }

    public final float requestsPerSecond() {
        return this.requestsPerSecond;
    }

    public final Retries retries() {
        return this.retries;
    }

    public final long throttledMillis() {
        return this.throttledMillis;
    }

    public final long throttledUntilMillis() {
        return this.throttledUntilMillis;
    }

    public final long total() {
        return this.total;
    }

    public final long updated() {
        return this.updated;
    }

    public final long versionConflicts() {
        return this.versionConflicts;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("batches");
        generator.write(this.batches);
        generator.writeKey("created");
        generator.write(this.created);
        generator.writeKey("deleted");
        generator.write(this.deleted);
        generator.writeKey("noops");
        generator.write(this.noops);
        generator.writeKey("requests_per_second");
        generator.write(this.requestsPerSecond);
        generator.writeKey("retries");
        this.retries.serialize(generator, mapper);
        generator.writeKey("throttled_millis");
        generator.write(this.throttledMillis);
        generator.writeKey("throttled_until_millis");
        generator.write(this.throttledUntilMillis);
        generator.writeKey("total");
        generator.write(this.total);
        generator.writeKey("updated");
        generator.write(this.updated);
        generator.writeKey("version_conflicts");
        generator.write(this.versionConflicts);
    }

    protected static void setupReindexStatusDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::batches, JsonpDeserializer.longDeserializer(), "batches");
        op.add(Builder::created, JsonpDeserializer.longDeserializer(), "created");
        op.add(Builder::deleted, JsonpDeserializer.longDeserializer(), "deleted");
        op.add(Builder::noops, JsonpDeserializer.longDeserializer(), "noops");
        op.add(Builder::requestsPerSecond, JsonpDeserializer.floatDeserializer(), "requests_per_second");
        op.add(Builder::retries, Retries._DESERIALIZER, "retries");
        op.add(Builder::throttledMillis, JsonpDeserializer.longDeserializer(), "throttled_millis");
        op.add(Builder::throttledUntilMillis, JsonpDeserializer.longDeserializer(), "throttled_until_millis");
        op.add(Builder::total, JsonpDeserializer.longDeserializer(), "total");
        op.add(Builder::updated, JsonpDeserializer.longDeserializer(), "updated");
        op.add(Builder::versionConflicts, JsonpDeserializer.longDeserializer(), "version_conflicts");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ReindexStatus> {
        private Long batches;
        private Long created;
        private Long deleted;
        private Long noops;
        private Float requestsPerSecond;
        private Retries retries;
        private Long throttledMillis;
        private Long throttledUntilMillis;
        private Long total;
        private Long updated;
        private Long versionConflicts;

        public final Builder batches(long value) {
            this.batches = value;
            return this;
        }

        public final Builder created(long value) {
            this.created = value;
            return this;
        }

        public final Builder deleted(long value) {
            this.deleted = value;
            return this;
        }

        public final Builder noops(long value) {
            this.noops = value;
            return this;
        }

        public final Builder requestsPerSecond(float value) {
            this.requestsPerSecond = Float.valueOf(value);
            return this;
        }

        public final Builder retries(Retries value) {
            this.retries = value;
            return this;
        }

        public final Builder retries(Function<Retries.Builder, ObjectBuilder<Retries>> fn) {
            return this.retries(fn.apply(new Retries.Builder()).build());
        }

        public final Builder throttledMillis(long value) {
            this.throttledMillis = value;
            return this;
        }

        public final Builder throttledUntilMillis(long value) {
            this.throttledUntilMillis = value;
            return this;
        }

        public final Builder total(long value) {
            this.total = value;
            return this;
        }

        public final Builder updated(long value) {
            this.updated = value;
            return this;
        }

        public final Builder versionConflicts(long value) {
            this.versionConflicts = value;
            return this;
        }

        @Override
        public ReindexStatus build() {
            this._checkSingleUse();
            return new ReindexStatus(this);
        }
    }
}

