/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.DataStreamTimestampField;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class DataStream
implements PlainJsonSerializable {
    @Nullable
    private final Boolean hidden;
    @Nullable
    private final DataStreamTimestampField timestampField;
    public static final JsonpDeserializer<DataStream> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataStream::setupDataStreamDeserializer);

    private DataStream(Builder builder) {
        this.hidden = builder.hidden;
        this.timestampField = builder.timestampField;
    }

    public static DataStream of(Function<Builder, ObjectBuilder<DataStream>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean hidden() {
        return this.hidden;
    }

    @Nullable
    public final DataStreamTimestampField timestampField() {
        return this.timestampField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.hidden != null) {
            generator.writeKey("hidden");
            generator.write(this.hidden);
        }
        if (this.timestampField != null) {
            generator.writeKey("timestamp_field");
            this.timestampField.serialize(generator, mapper);
        }
    }

    protected static void setupDataStreamDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::hidden, JsonpDeserializer.booleanDeserializer(), "hidden");
        op.add(Builder::timestampField, DataStreamTimestampField._DESERIALIZER, "timestamp_field");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DataStream> {
        @Nullable
        private Boolean hidden;
        @Nullable
        private DataStreamTimestampField timestampField;

        public final Builder hidden(@Nullable Boolean value) {
            this.hidden = value;
            return this;
        }

        public final Builder timestampField(@Nullable DataStreamTimestampField value) {
            this.timestampField = value;
            return this;
        }

        public final Builder timestampField(Function<DataStreamTimestampField.Builder, ObjectBuilder<DataStreamTimestampField>> fn) {
            return this.timestampField(fn.apply(new DataStreamTimestampField.Builder()).build());
        }

        @Override
        public DataStream build() {
            this._checkSingleUse();
            return new DataStream(this);
        }
    }
}

