/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class AttachmentProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final Long indexedChars;
    @Nullable
    private final String indexedCharsField;
    private final List<String> properties;
    @Nullable
    private final String targetField;
    @Nullable
    private final String resourceName;
    public static final JsonpDeserializer<AttachmentProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AttachmentProcessor::setupAttachmentProcessorDeserializer);

    private AttachmentProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.indexedChars = builder.indexedChars;
        this.indexedCharsField = builder.indexedCharsField;
        this.properties = ApiTypeHelper.unmodifiable(builder.properties);
        this.targetField = builder.targetField;
        this.resourceName = builder.resourceName;
    }

    public static AttachmentProcessor of(Function<Builder, ObjectBuilder<AttachmentProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Attachment;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public final Long indexedChars() {
        return this.indexedChars;
    }

    @Nullable
    public final String indexedCharsField() {
        return this.indexedCharsField;
    }

    public final List<String> properties() {
        return this.properties;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Nullable
    public final String resourceName() {
        return this.resourceName;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing);
        }
        if (this.indexedChars != null) {
            generator.writeKey("indexed_chars");
            generator.write(this.indexedChars);
        }
        if (this.indexedCharsField != null) {
            generator.writeKey("indexed_chars_field");
            generator.write(this.indexedCharsField);
        }
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartArray();
            for (String item0 : this.properties) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
        if (this.resourceName != null) {
            generator.writeKey("resource_name");
            generator.write(this.resourceName);
        }
    }

    protected static void setupAttachmentProcessorDeserializer(ObjectDeserializer<Builder> op) {
        AttachmentProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::indexedChars, JsonpDeserializer.longDeserializer(), "indexed_chars");
        op.add(Builder::indexedCharsField, JsonpDeserializer.stringDeserializer(), "indexed_chars_field");
        op.add(Builder::properties, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "properties");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
        op.add(Builder::resourceName, JsonpDeserializer.stringDeserializer(), "resource_name");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AttachmentProcessor> {
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private Long indexedChars;
        @Nullable
        private String indexedCharsField;
        @Nullable
        private List<String> properties;
        @Nullable
        private String targetField;
        @Nullable
        private String resourceName;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder indexedChars(@Nullable Long value) {
            this.indexedChars = value;
            return this;
        }

        public final Builder indexedCharsField(@Nullable String value) {
            this.indexedCharsField = value;
            return this;
        }

        public final Builder properties(List<String> list) {
            this.properties = Builder._listAddAll(this.properties, list);
            return this;
        }

        public final Builder properties(String value, String ... values) {
            this.properties = Builder._listAdd(this.properties, value, values);
            return this;
        }

        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        public final Builder resourceName(@Nullable String value) {
            this.resourceName = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AttachmentProcessor build() {
            this._checkSingleUse();
            return new AttachmentProcessor(this);
        }
    }
}

