/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class CsvProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final JsonData emptyValue;
    @Nullable
    private final String description;
    private final String field;
    @Nullable
    private final Boolean ignoreMissing;
    @Nullable
    private final String quote;
    @Nullable
    private final String separator;
    private final List<String> targetFields;
    private final boolean trim;
    public static final JsonpDeserializer<CsvProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CsvProcessor::setupCsvProcessorDeserializer);

    private CsvProcessor(Builder builder) {
        super(builder);
        this.emptyValue = ApiTypeHelper.requireNonNull(builder.emptyValue, this, "emptyValue");
        this.description = builder.description;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.ignoreMissing = builder.ignoreMissing;
        this.quote = builder.quote;
        this.separator = builder.separator;
        this.targetFields = ApiTypeHelper.unmodifiableRequired(builder.targetFields, (Object)this, "targetFields");
        this.trim = ApiTypeHelper.requireNonNull(builder.trim, this, "trim");
    }

    public static CsvProcessor of(Function<Builder, ObjectBuilder<CsvProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Csv;
    }

    public final JsonData emptyValue() {
        return this.emptyValue;
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nullable
    public final String quote() {
        return this.quote;
    }

    @Nullable
    public final String separator() {
        return this.separator;
    }

    public final List<String> targetFields() {
        return this.targetFields;
    }

    public final boolean trim() {
        return this.trim;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("empty_value");
        this.emptyValue.serialize(generator, mapper);
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing);
        }
        if (this.quote != null) {
            generator.writeKey("quote");
            generator.write(this.quote);
        }
        if (this.separator != null) {
            generator.writeKey("separator");
            generator.write(this.separator);
        }
        if (ApiTypeHelper.isDefined(this.targetFields)) {
            generator.writeKey("target_fields");
            generator.writeStartArray();
            for (String item0 : this.targetFields) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("trim");
        generator.write(this.trim);
    }

    protected static void setupCsvProcessorDeserializer(ObjectDeserializer<Builder> op) {
        CsvProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::emptyValue, JsonData._DESERIALIZER, "empty_value");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::quote, JsonpDeserializer.stringDeserializer(), "quote");
        op.add(Builder::separator, JsonpDeserializer.stringDeserializer(), "separator");
        op.add(Builder::targetFields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "target_fields");
        op.add(Builder::trim, JsonpDeserializer.booleanDeserializer(), "trim");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CsvProcessor> {
        private JsonData emptyValue;
        @Nullable
        private String description;
        private String field;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private String quote;
        @Nullable
        private String separator;
        private List<String> targetFields;
        private Boolean trim;

        public final Builder emptyValue(JsonData value) {
            this.emptyValue = value;
            return this;
        }

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        public final Builder quote(@Nullable String value) {
            this.quote = value;
            return this;
        }

        public final Builder separator(@Nullable String value) {
            this.separator = value;
            return this;
        }

        public final Builder targetFields(List<String> list) {
            this.targetFields = Builder._listAddAll(this.targetFields, list);
            return this;
        }

        public final Builder targetFields(String value, String ... values) {
            this.targetFields = Builder._listAdd(this.targetFields, value, values);
            return this;
        }

        public final Builder trim(boolean value) {
            this.trim = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CsvProcessor build() {
            this._checkSingleUse();
            return new CsvProcessor(this);
        }
    }
}

