/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.transport.httpclient5;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.entity.GzipDecompressingEntity;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.entity.BufferedHttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.HttpEntityWrapper;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.RequestLine;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.util.Args;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.NdJsonpSerializable;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.generic.OpenSearchClientException;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.GenericEndpoint;
import org.opensearch.client.transport.GenericSerializable;
import org.opensearch.client.transport.JsonEndpoint;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportException;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.endpoints.BooleanEndpoint;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5Options;
import org.opensearch.client.transport.httpclient5.DeadHostState;
import org.opensearch.client.transport.httpclient5.Response;
import org.opensearch.client.transport.httpclient5.ResponseException;
import org.opensearch.client.transport.httpclient5.WarningFailureException;
import org.opensearch.client.transport.httpclient5.WarningsHandler;
import org.opensearch.client.transport.httpclient5.internal.HttpUriRequestProducer;
import org.opensearch.client.transport.httpclient5.internal.Node;
import org.opensearch.client.transport.httpclient5.internal.NodeSelector;
import org.opensearch.client.util.MissingRequiredPropertyException;

public class ApacheHttpClient5Transport
implements OpenSearchTransport {
    private static final Log logger = LogFactory.getLog(ApacheHttpClient5Transport.class);
    static final ContentType JsonContentType = ContentType.APPLICATION_JSON;
    private final JsonpMapper mapper;
    private final CloseableHttpAsyncClient client;
    private final ApacheHttpClient5Options transportOptions;
    private final ConcurrentMap<HttpHost, DeadHostState> denylist = new ConcurrentHashMap<HttpHost, DeadHostState>();
    private final AtomicInteger lastNodeIndex = new AtomicInteger(0);
    private volatile NodeTuple<List<Node>> nodeTuple;
    private final NodeSelector nodeSelector;
    private final WarningsHandler warningsHandler;
    private final FailureListener failureListener;
    private final boolean compressionEnabled;
    private final boolean chunkedEnabled;
    private final String pathPrefix;
    private final List<Header> defaultHeaders;

    public ApacheHttpClient5Transport(CloseableHttpAsyncClient client, Header[] defaultHeaders, List<Node> nodes, JsonpMapper mapper, @Nullable TransportOptions options, String pathPrefix, FailureListener failureListener, NodeSelector nodeSelector, boolean strictDeprecationMode, boolean compressionEnabled, boolean chunkedEnabled) {
        this.mapper = mapper;
        this.client = client;
        this.defaultHeaders = Collections.unmodifiableList(Arrays.asList(defaultHeaders));
        this.pathPrefix = pathPrefix;
        this.transportOptions = options == null ? ApacheHttpClient5Options.initialOptions() : ApacheHttpClient5Options.of(options);
        this.warningsHandler = strictDeprecationMode ? WarningsHandler.STRICT : WarningsHandler.PERMISSIVE;
        this.nodeSelector = nodeSelector == null ? NodeSelector.ANY : nodeSelector;
        this.failureListener = failureListener == null ? new FailureListener() : failureListener;
        this.chunkedEnabled = chunkedEnabled;
        this.compressionEnabled = compressionEnabled;
        this.setNodes(nodes);
    }

    @Override
    public <RequestT, ResponseT, ErrorT> ResponseT performRequest(RequestT request, Endpoint<RequestT, ResponseT, ErrorT> endpoint, TransportOptions options) throws IOException {
        try {
            return this.performRequestAsync(request, endpoint, options).get();
        }
        catch (Exception ex) {
            Exception cause = ApacheHttpClient5Transport.extractAndWrapCause(ex);
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("unexpected exception type: must be either RuntimeException or IOException", cause);
        }
    }

    @Override
    public <RequestT, ResponseT, ErrorT> CompletableFuture<ResponseT> performRequestAsync(RequestT request, Endpoint<RequestT, ResponseT, ErrorT> endpoint, TransportOptions options) {
        ApacheHttpClient5Options requestOptions = options == null ? this.transportOptions : ApacheHttpClient5Options.of(options);
        CompletableFuture<Response> future = new CompletableFuture<Response>();
        HttpUriRequestBase clientReq = this.prepareLowLevelRequest(request, endpoint, requestOptions);
        WarningsHandler warningsHandler = requestOptions.getWarningsHandler() == null ? this.warningsHandler : requestOptions.getWarningsHandler();
        try {
            this.performRequestAsync(this.nextNodes(), requestOptions, clientReq, warningsHandler, future);
        }
        catch (IOException ex) {
            future.completeExceptionally(ex);
        }
        return future.thenApply(r -> {
            try {
                return this.prepareResponse((Response)r, endpoint);
            }
            catch (IOException ex) {
                throw new CompletionException(ex);
            }
        });
    }

    @Override
    public JsonpMapper jsonpMapper() {
        return this.mapper;
    }

    @Override
    public TransportOptions options() {
        return this.transportOptions;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private void performRequestAsync(final NodeTuple<Iterator<Node>> nodeTuple, final ApacheHttpClient5Options options, final HttpUriRequestBase request, final WarningsHandler warningsHandler, final CompletableFuture<Response> listener) {
        final RequestContext context = this.createContextForNextAttempt(options, request, (Node)((Iterator)nodeTuple.nodes).next(), nodeTuple.authCache);
        Future<ClassicHttpResponse> future = this.client.execute(context.requestProducer, context.asyncResponseConsumer, context.context, new FutureCallback<ClassicHttpResponse>(){

            @Override
            public void completed(ClassicHttpResponse httpResponse) {
                try {
                    ResponseOrResponseException responseOrResponseException = ApacheHttpClient5Transport.this.convertResponse(request, context.node, httpResponse, warningsHandler);
                    if (responseOrResponseException.responseException == null) {
                        listener.complete(responseOrResponseException.response);
                    } else if (((Iterator)nodeTuple.nodes).hasNext()) {
                        ApacheHttpClient5Transport.this.performRequestAsync(nodeTuple, options, request, warningsHandler, listener);
                    } else {
                        listener.completeExceptionally(responseOrResponseException.responseException);
                    }
                }
                catch (Exception e) {
                    listener.completeExceptionally(e);
                }
            }

            @Override
            public void failed(Exception failure) {
                try {
                    ApacheHttpClient5Transport.this.onFailure(context.node);
                    if (((Iterator)nodeTuple.nodes).hasNext()) {
                        ApacheHttpClient5Transport.this.performRequestAsync(nodeTuple, options, request, warningsHandler, listener);
                    } else {
                        listener.completeExceptionally(failure);
                    }
                }
                catch (Exception e) {
                    listener.completeExceptionally(e);
                }
            }

            @Override
            public void cancelled() {
                listener.completeExceptionally(new CancellationException("request was cancelled"));
            }
        });
        if (future instanceof Cancellable) {
            request.setDependency((Cancellable)((Object)future));
        }
    }

    private void setNodes(Collection<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be null or empty");
        }
        BasicAuthCache authCache = new BasicAuthCache();
        LinkedHashMap<HttpHost, Node> nodesByHost = new LinkedHashMap<HttpHost, Node>();
        for (Node node : nodes) {
            Objects.requireNonNull(node, "node cannot be null");
            nodesByHost.put(node.getHost(), node);
            authCache.put(node.getHost(), new BasicScheme());
        }
        this.nodeTuple = new NodeTuple(Collections.unmodifiableList(new ArrayList(nodesByHost.values())), authCache);
        this.denylist.clear();
    }

    private ResponseOrResponseException convertResponse(HttpUriRequestBase request, Node node, ClassicHttpResponse httpResponse, WarningsHandler warningsHandler) throws IOException {
        int statusCode = httpResponse.getCode();
        Optional.ofNullable(httpResponse.getEntity()).map(EntityDetails::getContentEncoding).filter("gzip"::equalsIgnoreCase).map(gzipHeaderValue -> new GzipDecompressingEntity(httpResponse.getEntity())).ifPresent(httpResponse::setEntity);
        Response response = new Response(new RequestLine(request), node.getHost(), httpResponse);
        Set<Integer> ignoreErrorCodes = ApacheHttpClient5Transport.getIgnoreErrorCodes("400,401,403,404,405", request.getMethod());
        if (ApacheHttpClient5Transport.isSuccessfulResponse(statusCode) || ignoreErrorCodes.contains(response.getStatusLine().getStatusCode())) {
            this.onResponse(node);
            if (warningsHandler.warningsShouldFailRequest(response.getWarnings())) {
                throw new WarningFailureException(response);
            }
            return new ResponseOrResponseException(response);
        }
        ResponseException responseException = new ResponseException(response);
        if (ApacheHttpClient5Transport.isRetryStatus(statusCode)) {
            this.onFailure(node);
            return new ResponseOrResponseException(responseException);
        }
        this.onResponse(node);
        throw responseException;
    }

    private static Set<Integer> getIgnoreErrorCodes(String ignoreString, String requestMethod) {
        Set<Integer> ignoreErrorCodes;
        if (ignoreString == null) {
            ignoreErrorCodes = "HEAD".equals(requestMethod) ? Collections.singleton(404) : Collections.emptySet();
        } else {
            String[] ignoresArray = ignoreString.split(",");
            ignoreErrorCodes = new HashSet();
            if ("HEAD".equals(requestMethod)) {
                ignoreErrorCodes.add(404);
            }
            for (String ignoreCode : ignoresArray) {
                try {
                    ignoreErrorCodes.add(Integer.valueOf(ignoreCode));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("ignore value should be a number, found [" + ignoreString + "] instead", e);
                }
            }
        }
        return ignoreErrorCodes;
    }

    private static boolean isSuccessfulResponse(int statusCode) {
        return statusCode < 300;
    }

    private static boolean isRetryStatus(int statusCode) {
        switch (statusCode) {
            case 502: 
            case 503: 
            case 504: {
                return true;
            }
        }
        return false;
    }

    private NodeTuple<Iterator<Node>> nextNodes() throws IOException {
        NodeTuple<List<Node>> nodeTuple = this.nodeTuple;
        Iterable<Node> hosts = ApacheHttpClient5Transport.selectNodes(nodeTuple, this.denylist, this.lastNodeIndex, this.nodeSelector);
        return new NodeTuple<Iterator<Node>>(hosts.iterator(), nodeTuple.authCache);
    }

    static Iterable<Node> selectNodes(NodeTuple<List<Node>> nodeTuple, Map<HttpHost, DeadHostState> denylist, AtomicInteger lastNodeIndex, NodeSelector nodeSelector) throws IOException {
        ArrayList<Node> livingNodes = new ArrayList<Node>(Math.max(0, ((List)nodeTuple.nodes).size() - denylist.size()));
        ArrayList<DeadNode> deadNodes = new ArrayList<DeadNode>(denylist.size());
        for (Node node : (List)nodeTuple.nodes) {
            DeadHostState deadness = denylist.get(node.getHost());
            if (deadness == null || deadness.shallBeRetried()) {
                livingNodes.add(node);
                continue;
            }
            deadNodes.add(new DeadNode(node, deadness));
        }
        if (!livingNodes.isEmpty()) {
            ArrayList<Node> selectedLivingNodes = new ArrayList<Node>(livingNodes);
            nodeSelector.select(selectedLivingNodes);
            if (!selectedLivingNodes.isEmpty()) {
                Collections.rotate(selectedLivingNodes, lastNodeIndex.getAndIncrement());
                return selectedLivingNodes;
            }
        }
        if (!deadNodes.isEmpty()) {
            ArrayList selectedDeadNodes = new ArrayList(deadNodes);
            nodeSelector.select(() -> new DeadNodeIteratorAdapter(selectedDeadNodes.iterator()));
            if (!selectedDeadNodes.isEmpty()) {
                return Collections.singletonList(((DeadNode)Collections.min(selectedDeadNodes)).node);
            }
        }
        throw new IOException("NodeSelector [" + nodeSelector + "] rejected all nodes, living " + livingNodes + " and dead " + deadNodes);
    }

    private void onFailure(Node node) {
        block3: {
            DeadHostState previousDeadHostState;
            do {
                if ((previousDeadHostState = this.denylist.putIfAbsent(node.getHost(), new DeadHostState(DeadHostState.DEFAULT_TIME_SUPPLIER))) != null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("added [" + node + "] to denylist"));
                }
                break block3;
            } while (!this.denylist.replace(node.getHost(), previousDeadHostState, new DeadHostState(previousDeadHostState)));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("updated [" + node + "] already in denylist"));
            }
        }
        this.failureListener.onFailure(node);
    }

    private RequestContext createContextForNextAttempt(ApacheHttpClient5Options options, HttpUriRequestBase request, Node node, AuthCache authCache) {
        request.reset();
        return new RequestContext(options, request, node, authCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ResponseT, ErrorT> ResponseT prepareResponse(Response clientResp, Endpoint<?, ResponseT, ErrorT> endpoint) throws IOException {
        int statusCode = clientResp.getStatusLine().getStatusCode();
        if (statusCode == 403) {
            throw new TransportException("Forbidden access", new ResponseException(clientResp));
        }
        if (statusCode == 401) {
            throw new TransportException("Unauthorized access", new ResponseException(clientResp));
        }
        if (endpoint.isError(statusCode)) {
            HttpEntity entity = clientResp.getEntity();
            if (entity == null) {
                throw new TransportException("Expecting a response body, but none was sent", new ResponseException(clientResp));
            }
            if (endpoint instanceof GenericEndpoint) {
                GenericEndpoint rawEndpoint = (GenericEndpoint)endpoint;
                RequestLine requestLine = clientResp.getRequestLine();
                StatusLine statusLine = clientResp.getStatusLine();
                entity = new BufferedHttpEntity(entity);
                InputStream content = entity.getContent();
                try {
                    Object error = rawEndpoint.responseDeserializer(requestLine.getUri(), requestLine.getMethod(), requestLine.getProtocolVersion().format(), statusLine.getStatusCode(), statusLine.getReasonPhrase(), Arrays.stream(clientResp.getHeaders()).map(h -> new AbstractMap.SimpleEntry<String, String>(h.getName(), h.getValue())).collect(Collectors.toList()), entity.getContentType(), content);
                    throw rawEndpoint.exceptionConverter(statusCode, error);
                }
                catch (Throwable throwable) {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            JsonpDeserializer<ErrorT> errorDeserializer = endpoint.errorDeserializer(statusCode);
            if (errorDeserializer == null) {
                throw new TransportException("Request failed with status code '" + statusCode + "'", new ResponseException(clientResp));
            }
            entity = new BufferedHttpEntity(entity);
            try {
                InputStream content = entity.getContent();
                JsonParser parser = this.mapper.jsonProvider().createParser(content);
                try {
                    ErrorT error = errorDeserializer.deserialize(parser, this.mapper);
                    throw endpoint.exceptionConverter(statusCode, error);
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    }
                    throw throwable;
                }
            }
            catch (MissingRequiredPropertyException errorEx) {
                ResponseT ResponseT;
                try {
                    ResponseT response;
                    ResponseT = response = this.decodeResponse(statusCode, entity, clientResp, endpoint);
                }
                catch (Exception respEx) {
                    throw new TransportException("Failed to decode error response", new ResponseException(clientResp));
                }
                EntityUtils.consume(clientResp.getEntity());
                return ResponseT;
            }
        }
        ResponseT ResponseT = this.decodeResponse(statusCode, clientResp.getEntity(), clientResp, endpoint);
        return ResponseT;
        finally {
            EntityUtils.consume(clientResp.getEntity());
        }
    }

    private <RequestT> HttpUriRequestBase prepareLowLevelRequest(RequestT request, Endpoint<RequestT, ?, ?> endpoint, @Nullable ApacheHttpClient5Options options) {
        String method = endpoint.method(request);
        String path = endpoint.requestUrl(request);
        Map<String, String> params = endpoint.queryParameters(request);
        URI uri = ApacheHttpClient5Transport.buildUri(this.pathPrefix, path, params);
        HttpUriRequestBase clientReq = new HttpUriRequestBase(method, uri);
        if (endpoint.hasRequestBody()) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ContentType contentType = JsonContentType;
            if (request instanceof NdJsonpSerializable) {
                this.writeNdJson((NdJsonpSerializable)request, baos);
            } else if (request instanceof GenericSerializable) {
                contentType = ContentType.parse(((GenericSerializable)request).serialize(baos));
            } else {
                JsonGenerator generator = this.mapper.jsonProvider().createGenerator(baos);
                this.mapper.serialize(request, generator);
                generator.close();
            }
            this.addRequestBody(clientReq, new ByteArrayEntity(baos.toByteArray(), contentType));
        }
        this.setHeaders(clientReq, options.headers());
        if (options.getRequestConfig() != null) {
            clientReq.setConfig(options.getRequestConfig());
        }
        return clientReq;
    }

    private HttpUriRequestBase addRequestBody(HttpUriRequestBase httpRequest, HttpEntity entity) {
        if (entity != null) {
            if (this.compressionEnabled) {
                entity = this.chunkedEnabled ? new ContentCompressingEntity(entity, this.chunkedEnabled) : new ContentCompressingEntity(entity);
            } else if (this.chunkedEnabled) {
                entity = new ContentHttpEntity(entity, this.chunkedEnabled);
            }
            httpRequest.setEntity(entity);
        }
        return httpRequest;
    }

    private void setHeaders(HttpRequest httpRequest, Collection<Map.Entry<String, String>> requestHeaders) {
        HashSet<String> requestNames = new HashSet<String>(requestHeaders.size());
        for (Map.Entry<String, String> requestHeader : requestHeaders) {
            httpRequest.addHeader(new BasicHeader(requestHeader.getKey(), requestHeader.getValue()));
            requestNames.add(requestHeader.getKey());
        }
        for (Header defaultHeader : this.defaultHeaders) {
            if (requestNames.contains(defaultHeader.getName())) continue;
            httpRequest.addHeader(defaultHeader);
        }
        if (this.compressionEnabled) {
            httpRequest.addHeader("Accept-Encoding", "gzip");
        }
    }

    private void onResponse(Node node) {
        DeadHostState removedHost = (DeadHostState)this.denylist.remove(node.getHost());
        if (logger.isDebugEnabled() && removedHost != null) {
            logger.debug((Object)("removed [" + node + "] from denylist"));
        }
    }

    private <ResponseT> ResponseT decodeResponse(int statusCode, @Nullable HttpEntity entity, Response clientResp, Endpoint<?, ResponseT, ?> endpoint) throws IOException {
        if (endpoint instanceof BooleanEndpoint) {
            BooleanEndpoint bep = (BooleanEndpoint)endpoint;
            BooleanResponse response = new BooleanResponse(bep.getResult(statusCode));
            return (ResponseT)response;
        }
        if (endpoint instanceof JsonEndpoint) {
            JsonEndpoint jsonEndpoint = (JsonEndpoint)endpoint;
            ResponseT response = null;
            JsonpDeserializer responseParser = jsonEndpoint.responseDeserializer();
            if (responseParser != null) {
                if (entity == null) {
                    throw new TransportException("Expecting a response body, but none was sent", new ResponseException(clientResp));
                }
                InputStream content = entity.getContent();
                try (JsonParser parser = this.mapper.jsonProvider().createParser(content);){
                    response = responseParser.deserialize(parser, this.mapper);
                }
            }
            return response;
        }
        if (endpoint instanceof GenericEndpoint) {
            GenericEndpoint rawEndpoint = (GenericEndpoint)endpoint;
            String contentType = null;
            InputStream content = null;
            if (entity != null) {
                contentType = entity.getContentType();
                content = entity.getContent();
            }
            RequestLine requestLine = clientResp.getRequestLine();
            StatusLine statusLine = clientResp.getStatusLine();
            return rawEndpoint.responseDeserializer(requestLine.getUri(), requestLine.getMethod(), requestLine.getProtocolVersion().format(), statusLine.getStatusCode(), statusLine.getReasonPhrase(), Arrays.stream(clientResp.getHeaders()).map(h -> new AbstractMap.SimpleEntry<String, String>(h.getName(), h.getValue())).collect(Collectors.toList()), contentType, content);
        }
        throw new TransportException("Unhandled endpoint type: '" + endpoint.getClass().getName() + "'");
    }

    private void writeNdJson(NdJsonpSerializable value, ByteArrayOutputStream baos) {
        Iterator<?> values = value._serializables();
        while (values.hasNext()) {
            Object item = values.next();
            if (item instanceof NdJsonpSerializable && item != value) {
                this.writeNdJson((NdJsonpSerializable)item, baos);
                continue;
            }
            JsonGenerator generator = this.mapper.jsonProvider().createGenerator(baos);
            this.mapper.serialize(item, generator);
            generator.close();
            baos.write(10);
        }
    }

    private static URI buildUri(String pathPrefix, String path, Map<String, String> params) {
        Objects.requireNonNull(path, "path must not be null");
        try {
            String fullPath = pathPrefix != null && !pathPrefix.isEmpty() ? (pathPrefix.endsWith("/") && path.startsWith("/") ? pathPrefix.substring(0, pathPrefix.length() - 1) + path : (pathPrefix.endsWith("/") || path.startsWith("/") ? pathPrefix + path : pathPrefix + "/" + path)) : path;
            URIBuilder uriBuilder = new URIBuilder(fullPath);
            for (Map.Entry<String, String> param : params.entrySet()) {
                uriBuilder.addParameter(param.getKey(), param.getValue());
            }
            return new URI(uriBuilder.build().toASCIIString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private static Exception extractAndWrapCause(Exception exception) {
        Exception e;
        if (exception instanceof InterruptedException) {
            throw new RuntimeException("thread waiting for the response was interrupted", exception);
        }
        if (exception instanceof ExecutionException) {
            Throwable t;
            ExecutionException executionException = (ExecutionException)exception;
            Throwable throwable = t = executionException.getCause() == null ? executionException : executionException.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            exception = t;
        }
        if (exception instanceof ConnectTimeoutException) {
            e = new ConnectTimeoutException(exception.getMessage());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof SocketTimeoutException) {
            e = new SocketTimeoutException(exception.getMessage());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof ConnectionClosedException) {
            e = new ConnectionClosedException(exception.getMessage());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof SSLHandshakeException) {
            e = new SSLHandshakeException(exception.getMessage() + "\nSee https://opensearch.org/docs/latest/clients/java/ for troubleshooting.");
            e.initCause(exception);
            return e;
        }
        if (exception instanceof ConnectException) {
            e = new ConnectException(exception.getMessage());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof ResponseException) {
            try {
                e = new ResponseException(((ResponseException)exception).getResponse());
                e.initCause(exception);
                return e;
            }
            catch (IOException ex) {
                return new IOException(exception.getMessage(), exception);
            }
        }
        if (exception instanceof IOException) {
            return new IOException(exception.getMessage(), exception);
        }
        if (exception instanceof OpenSearchException) {
            e = new OpenSearchException(((OpenSearchException)exception).response());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof OpenSearchClientException) {
            e = new OpenSearchClientException(((OpenSearchClientException)exception).response());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof RuntimeException) {
            return new RuntimeException(exception.getMessage(), exception);
        }
        return new RuntimeException("error while performing request", exception);
    }

    private static class ByteArrayInputOutputStream
    extends ByteArrayOutputStream {
        ByteArrayInputOutputStream(int size) {
            super(size);
        }

        public InputStream asInput() {
            return new ByteArrayInputStream(this.buf, 0, this.count);
        }
    }

    public static class ContentHttpEntity
    extends HttpEntityWrapper {
        private Optional<Boolean> chunkedEnabled;

        public ContentHttpEntity(HttpEntity entity) {
            super(entity);
            this.chunkedEnabled = Optional.empty();
        }

        public ContentHttpEntity(HttpEntity entity, boolean chunkedEnabled) {
            super(entity);
            this.chunkedEnabled = Optional.of(chunkedEnabled);
        }

        @Override
        public boolean isChunked() {
            return this.chunkedEnabled.orElseGet(() -> super.isChunked());
        }
    }

    public static class ContentCompressingEntity
    extends HttpEntityWrapper {
        private static final String GZIP_CODEC = "gzip";
        private Optional<Boolean> chunkedEnabled;

        public ContentCompressingEntity(HttpEntity entity) {
            super(entity);
            this.chunkedEnabled = Optional.empty();
        }

        @Override
        public String getContentEncoding() {
            return GZIP_CODEC;
        }

        public ContentCompressingEntity(HttpEntity entity, boolean chunkedEnabled) {
            super(entity);
            this.chunkedEnabled = Optional.of(chunkedEnabled);
        }

        @Override
        public InputStream getContent() throws IOException {
            ByteArrayInputOutputStream out = new ByteArrayInputOutputStream(1024);
            try (GZIPOutputStream gzipOut = new GZIPOutputStream(out);){
                super.writeTo(gzipOut);
            }
            return out.asInput();
        }

        @Override
        public boolean isChunked() {
            return this.chunkedEnabled.orElseGet(() -> super.isChunked());
        }

        @Override
        public long getContentLength() {
            if (this.chunkedEnabled.isPresent()) {
                if (this.chunkedEnabled.get().booleanValue()) {
                    return -1L;
                }
                long size = 0L;
                byte[] buf = new byte[8192];
                int nread = 0;
                try (InputStream is = this.getContent();){
                    while ((nread = is.read(buf)) > 0) {
                        size += (long)nread;
                    }
                }
                catch (IOException ex) {
                    size = -1L;
                }
                return size;
            }
            return -1L;
        }

        @Override
        public void writeTo(OutputStream outStream) throws IOException {
            Args.notNull(outStream, "Output stream");
            GZIPOutputStream gzip = new GZIPOutputStream(outStream);
            super.writeTo(gzip);
            gzip.close();
        }
    }

    public static class FailureListener {
        public void onFailure(Node node) {
        }
    }

    private static class ResponseOrResponseException {
        private final Response response;
        private final ResponseException responseException;

        ResponseOrResponseException(Response response) {
            this.response = Objects.requireNonNull(response);
            this.responseException = null;
        }

        ResponseOrResponseException(ResponseException responseException) {
            this.responseException = Objects.requireNonNull(responseException);
            this.response = null;
        }
    }

    private static class WrappingAuthCache
    implements AuthCache {
        private final HttpClientContext context;
        private final AuthCache delegate;
        private final boolean usePersistentCredentials = true;

        WrappingAuthCache(HttpClientContext context, AuthCache delegate) {
            this.context = context;
            this.delegate = delegate;
        }

        @Override
        public void put(HttpHost host, AuthScheme authScheme) {
            this.delegate.put(host, authScheme);
        }

        @Override
        public AuthScheme get(HttpHost host) {
            CredentialsProvider credsProvider;
            AuthScheme authScheme = this.delegate.get(host);
            if (authScheme != null && (credsProvider = this.context.getCredentialsProvider()) != null) {
                String schemeName = authScheme.getName();
                AuthScope authScope = new AuthScope(host, null, schemeName);
                Credentials creds = credsProvider.getCredentials(authScope, this.context);
                if (authScheme instanceof BasicScheme) {
                    ((BasicScheme)authScheme).initPreemptive(creds);
                }
                if (creds == null) {
                    return null;
                }
            }
            return authScheme;
        }

        @Override
        public void remove(HttpHost host) {
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }
    }

    private static class RequestContext {
        private final Node node;
        private final AsyncRequestProducer requestProducer;
        private final AsyncResponseConsumer<ClassicHttpResponse> asyncResponseConsumer;
        private final HttpClientContext context;

        RequestContext(ApacheHttpClient5Options options, HttpUriRequestBase request, Node node, AuthCache authCache) {
            this.node = node;
            this.requestProducer = HttpUriRequestProducer.create(request, node.getHost());
            this.asyncResponseConsumer = options.getHttpAsyncResponseConsumerFactory().createHttpAsyncResponseConsumer();
            this.context = HttpClientContext.create();
            this.context.setAuthCache(new WrappingAuthCache(this.context, authCache));
        }
    }

    private static class DeadNodeIteratorAdapter
    implements Iterator<Node> {
        private final Iterator<DeadNode> itr;

        private DeadNodeIteratorAdapter(Iterator<DeadNode> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Node next() {
            return this.itr.next().node;
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private static class DeadNode
    implements Comparable<DeadNode> {
        final Node node;
        final DeadHostState deadness;

        DeadNode(Node node, DeadHostState deadness) {
            this.node = node;
            this.deadness = deadness;
        }

        public String toString() {
            return this.node.toString();
        }

        @Override
        public int compareTo(DeadNode rhs) {
            return this.deadness.compareTo(rhs.deadness);
        }
    }

    static class NodeTuple<T> {
        final T nodes;
        final AuthCache authCache;

        NodeTuple(T nodes, AuthCache authCache) {
            this.nodes = nodes;
            this.authCache = authCache;
        }
    }
}

