/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.transport.httpclient5;

import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.ssl.ClientTlsStrategyBuilder;
import org.apache.hc.core5.function.Factory;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.reactor.ssl.TlsDetails;
import org.apache.hc.core5.util.Timeout;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.httpclient5.ApacheHttpClient5Transport;
import org.opensearch.client.transport.httpclient5.internal.Node;
import org.opensearch.client.transport.httpclient5.internal.NodeSelector;

public class ApacheHttpClient5TransportBuilder {
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 1000;
    public static final int DEFAULT_RESPONSE_TIMEOUT_MILLIS = 30000;
    public static final int DEFAULT_MAX_CONN_PER_ROUTE = 10;
    public static final int DEFAULT_MAX_CONN_TOTAL = 30;
    private static final Header[] EMPTY_HEADERS = new Header[0];
    private final List<Node> nodes;
    private Header[] defaultHeaders = EMPTY_HEADERS;
    private ApacheHttpClient5Transport.FailureListener failureListener;
    private HttpClientConfigCallback httpClientConfigCallback;
    private RequestConfigCallback requestConfigCallback;
    private String pathPrefix;
    private NodeSelector nodeSelector = NodeSelector.ANY;
    private boolean strictDeprecationMode = false;
    private boolean compressionEnabled = false;
    private Optional<Boolean> chunkedEnabled;
    private JsonpMapper mapper;
    private TransportOptions options;

    ApacheHttpClient5TransportBuilder(List<Node> nodes) {
        if (nodes == null || nodes.isEmpty()) {
            throw new IllegalArgumentException("nodes must not be null or empty");
        }
        for (Node node : nodes) {
            if (node != null) continue;
            throw new IllegalArgumentException("node cannot be null");
        }
        this.nodes = nodes;
        this.chunkedEnabled = Optional.empty();
    }

    public ApacheHttpClient5TransportBuilder setDefaultHeaders(Header[] defaultHeaders) {
        Objects.requireNonNull(defaultHeaders, "defaultHeaders must not be null");
        for (Header defaultHeader : defaultHeaders) {
            Objects.requireNonNull(defaultHeader, "default header must not be null");
        }
        this.defaultHeaders = defaultHeaders;
        return this;
    }

    public ApacheHttpClient5TransportBuilder setFailureListener(ApacheHttpClient5Transport.FailureListener failureListener) {
        Objects.requireNonNull(failureListener, "failureListener must not be null");
        this.failureListener = failureListener;
        return this;
    }

    public ApacheHttpClient5TransportBuilder setHttpClientConfigCallback(HttpClientConfigCallback httpClientConfigCallback) {
        Objects.requireNonNull(httpClientConfigCallback, "httpClientConfigCallback must not be null");
        this.httpClientConfigCallback = httpClientConfigCallback;
        return this;
    }

    public ApacheHttpClient5TransportBuilder setRequestConfigCallback(RequestConfigCallback requestConfigCallback) {
        Objects.requireNonNull(requestConfigCallback, "requestConfigCallback must not be null");
        this.requestConfigCallback = requestConfigCallback;
        return this;
    }

    public ApacheHttpClient5TransportBuilder setPathPrefix(String pathPrefix) {
        this.pathPrefix = ApacheHttpClient5TransportBuilder.cleanPathPrefix(pathPrefix);
        return this;
    }

    public ApacheHttpClient5TransportBuilder setMapper(JsonpMapper mapper) {
        this.mapper = mapper;
        return this;
    }

    public ApacheHttpClient5TransportBuilder setOptions(TransportOptions options) {
        this.options = options;
        return this;
    }

    public static String cleanPathPrefix(String pathPrefix) {
        Objects.requireNonNull(pathPrefix, "pathPrefix must not be null");
        if (pathPrefix.isEmpty()) {
            throw new IllegalArgumentException("pathPrefix must not be empty");
        }
        String cleanPathPrefix = pathPrefix;
        if (!cleanPathPrefix.startsWith("/")) {
            cleanPathPrefix = "/" + cleanPathPrefix;
        }
        if (cleanPathPrefix.endsWith("/") && cleanPathPrefix.length() > 1 && (cleanPathPrefix = cleanPathPrefix.substring(0, cleanPathPrefix.length() - 1)).endsWith("/")) {
            throw new IllegalArgumentException("pathPrefix is malformed. too many trailing slashes: [" + pathPrefix + "]");
        }
        return cleanPathPrefix;
    }

    public ApacheHttpClient5TransportBuilder setNodeSelector(NodeSelector nodeSelector) {
        Objects.requireNonNull(nodeSelector, "nodeSelector must not be null");
        this.nodeSelector = nodeSelector;
        return this;
    }

    public ApacheHttpClient5TransportBuilder setStrictDeprecationMode(boolean strictDeprecationMode) {
        this.strictDeprecationMode = strictDeprecationMode;
        return this;
    }

    public ApacheHttpClient5TransportBuilder setCompressionEnabled(boolean compressionEnabled) {
        this.compressionEnabled = compressionEnabled;
        return this;
    }

    public ApacheHttpClient5TransportBuilder setChunkedEnabled(boolean chunkedEnabled) {
        this.chunkedEnabled = Optional.of(chunkedEnabled);
        return this;
    }

    public ApacheHttpClient5Transport build() {
        if (this.failureListener == null) {
            this.failureListener = new ApacheHttpClient5Transport.FailureListener();
        }
        CloseableHttpAsyncClient httpClient = AccessController.doPrivileged(this::createHttpClient);
        if (this.mapper == null) {
            this.mapper = new JacksonJsonpMapper();
        }
        ApacheHttpClient5Transport transport = new ApacheHttpClient5Transport(httpClient, this.defaultHeaders, this.nodes, this.mapper, this.options, this.pathPrefix, this.failureListener, this.nodeSelector, this.strictDeprecationMode, this.compressionEnabled, this.chunkedEnabled.orElse(false));
        httpClient.start();
        return transport;
    }

    public static ApacheHttpClient5TransportBuilder builder(Node ... nodes) {
        return new ApacheHttpClient5TransportBuilder(nodes == null ? null : Arrays.asList(nodes));
    }

    public static ApacheHttpClient5TransportBuilder builder(HttpHost ... hosts) {
        if (hosts == null || hosts.length == 0) {
            throw new IllegalArgumentException("hosts must not be null nor empty");
        }
        List<Node> nodes = Arrays.stream(hosts).map(Node::new).collect(Collectors.toList());
        return new ApacheHttpClient5TransportBuilder(nodes);
    }

    private CloseableHttpAsyncClient createHttpClient() {
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds(1000L)).setResponseTimeout(Timeout.ofMilliseconds(30000L));
        if (this.requestConfigCallback != null) {
            requestConfigBuilder = this.requestConfigCallback.customizeRequestConfig(requestConfigBuilder);
        }
        try {
            TlsStrategy tlsStrategy = ClientTlsStrategyBuilder.create().setSslContext(SSLContext.getDefault()).setTlsDetailsFactory(new Factory<SSLEngine, TlsDetails>(){

                @Override
                public TlsDetails create(SSLEngine sslEngine) {
                    return new TlsDetails(sslEngine.getSession(), sslEngine.getApplicationProtocol());
                }
            }).build();
            PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setMaxConnPerRoute(10).setMaxConnTotal(30).setTlsStrategy(tlsStrategy).build();
            HttpAsyncClientBuilder httpClientBuilder = HttpAsyncClientBuilder.create().setDefaultRequestConfig(requestConfigBuilder.build()).setConnectionManager(connectionManager).setTargetAuthenticationStrategy(DefaultAuthenticationStrategy.INSTANCE).disableAutomaticRetries();
            if (this.httpClientConfigCallback != null) {
                httpClientBuilder = this.httpClientConfigCallback.customizeHttpClient(httpClientBuilder);
            }
            HttpAsyncClientBuilder finalBuilder = httpClientBuilder;
            return AccessController.doPrivileged(finalBuilder::build);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("could not create the default ssl context", e);
        }
    }

    public static interface HttpClientConfigCallback {
        public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder var1);
    }

    public static interface RequestConfigCallback {
        public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder var1);
    }
}

