/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.serializer.DeserializationContext;
import jakarta.json.bind.serializer.JsonbDeserializer;
import jakarta.json.stream.JsonParser;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.JsonbParser;
import org.eclipse.yasson.internal.ProcessingContext;
import org.eclipse.yasson.internal.serializer.CurrentItem;
import org.eclipse.yasson.internal.serializer.DeserializerBuilder;

public class OptionalObjectDeserializer
implements JsonbDeserializer<Optional<?>> {
    private final CurrentItem<?> wrapper;
    private final Type optionalValueType;

    public OptionalObjectDeserializer(DeserializerBuilder deserializerBuilder) {
        this.wrapper = deserializerBuilder.getWrapper();
        this.optionalValueType = this.resolveOptionalType(deserializerBuilder.getRuntimeType());
    }

    @Override
    public Optional<?> deserialize(JsonParser parser, DeserializationContext ctx, Type rtType) {
        JsonbContext jsonbContext = ((ProcessingContext)((Object)ctx)).getJsonbContext();
        JsonParser.Event lastEvent = ((JsonbParser)parser).getCurrentLevel().getLastEvent();
        if (lastEvent == JsonParser.Event.VALUE_NULL) {
            return Optional.empty();
        }
        JsonbDeserializer<?> deserializer = ((DeserializerBuilder)((DeserializerBuilder)new DeserializerBuilder(jsonbContext).withType(this.optionalValueType)).withWrapper(this.wrapper)).withJsonValueType(lastEvent).build();
        return Optional.of(deserializer.deserialize(parser, ctx, this.optionalValueType));
    }

    private Type resolveOptionalType(Type runtimeType) {
        if (runtimeType instanceof ParameterizedType) {
            return ((ParameterizedType)runtimeType).getActualTypeArguments()[0];
        }
        return Object.class;
    }
}

