/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import jakarta.json.bind.JsonbException;
import jakarta.json.stream.JsonGenerator;
import java.io.UnsupportedEncodingException;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.Marshaller;
import org.eclipse.yasson.internal.model.customization.Customization;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeSerializer;

public class StringTypeSerializer
extends AbstractValueTypeSerializer<String> {
    public StringTypeSerializer(Customization customization) {
        super(customization);
    }

    private String toJson(String object, JsonbContext jsonbContext) {
        if (((Boolean)jsonbContext.getConfig().getProperty("jsonb.strict-ijson").orElse(false)).booleanValue()) {
            try {
                String newString = new String(object.getBytes("UTF-8"), "UTF-8");
                if (!newString.equals(object)) {
                    throw new JsonbException(Messages.getMessage(MessageKeys.UNPAIRED_SURROGATE, new Object[0]));
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return object;
    }

    @Override
    protected void serialize(String obj, JsonGenerator generator, Marshaller marshaller) {
        generator.write(this.toJson(obj, marshaller.getJsonbContext()));
    }
}

