/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.opensearch.client.RequestOptions;

public final class Request {
    private final String method;
    private final String endpoint;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private HttpEntity entity;
    private RequestOptions options = RequestOptions.DEFAULT;

    public Request(String method, String endpoint) {
        this.method = Objects.requireNonNull(method, "method cannot be null");
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint cannot be null");
    }

    public String getMethod() {
        return this.method;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void addParameter(String name, String value) {
        Objects.requireNonNull(name, "url parameter name cannot be null");
        if (this.parameters.containsKey(name)) {
            throw new IllegalArgumentException("url parameter [" + name + "] has already been set to [" + this.parameters.get(name) + "]");
        }
        this.parameters.put(name, value);
    }

    public void addParameters(Map<String, String> paramSource) {
        paramSource.forEach(this::addParameter);
    }

    public Map<String, String> getParameters() {
        if (this.options.getParameters().isEmpty()) {
            return Collections.unmodifiableMap(this.parameters);
        }
        HashMap<String, String> combinedParameters = new HashMap<String, String>(this.parameters);
        combinedParameters.putAll(this.options.getParameters());
        return Collections.unmodifiableMap(combinedParameters);
    }

    public void setEntity(HttpEntity entity) {
        this.entity = entity;
    }

    public void setJsonEntity(String entity) {
        this.setEntity(entity == null ? null : new NStringEntity(entity, ContentType.APPLICATION_JSON));
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public void setOptions(RequestOptions options) {
        Objects.requireNonNull(options, "options cannot be null");
        this.options = options;
    }

    public void setOptions(RequestOptions.Builder options) {
        Objects.requireNonNull(options, "options cannot be null");
        this.options = options.build();
    }

    public RequestOptions getOptions() {
        return this.options;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Request{");
        b.append("method='").append(this.method).append('\'');
        b.append(", endpoint='").append(this.endpoint).append('\'');
        if (!this.parameters.isEmpty()) {
            b.append(", params=").append(this.parameters);
        }
        if (this.entity != null) {
            b.append(", entity=").append(this.entity);
        }
        b.append(", options=").append(this.options);
        return b.append('}').toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Request other = (Request)obj;
        return this.method.equals(other.method) && this.endpoint.equals(other.endpoint) && this.parameters.equals(other.parameters) && Objects.equals(this.entity, other.entity) && this.options.equals(other.options);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.endpoint, this.parameters, this.entity, this.options);
    }
}

