/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.DistanceUnit;
import org.opensearch.client.opensearch._types.GeoDistanceType;
import org.opensearch.client.opensearch._types.GeoLocation;
import org.opensearch.client.opensearch._types.SortMode;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOptionsVariant;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class GeoDistanceSort
implements SortOptionsVariant,
JsonpSerializable {
    private final String field;
    private final List<GeoLocation> location;
    @Nullable
    private final SortMode mode;
    @Nullable
    private final GeoDistanceType distanceType;
    @Nullable
    private final Boolean ignoreUnmapped;
    @Nullable
    private final SortOrder order;
    @Nullable
    private final DistanceUnit unit;
    public static final JsonpDeserializer<GeoDistanceSort> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoDistanceSort::setupGeoDistanceSortDeserializer);

    private GeoDistanceSort(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.location = ApiTypeHelper.unmodifiableRequired(builder.location, (Object)this, "location");
        this.mode = builder.mode;
        this.distanceType = builder.distanceType;
        this.ignoreUnmapped = builder.ignoreUnmapped;
        this.order = builder.order;
        this.unit = builder.unit;
    }

    public static GeoDistanceSort of(Function<Builder, ObjectBuilder<GeoDistanceSort>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SortOptions.Kind _sortOptionsKind() {
        return SortOptions.Kind.GeoDistance;
    }

    public final String field() {
        return this.field;
    }

    public final List<GeoLocation> location() {
        return this.location;
    }

    @Nullable
    public final SortMode mode() {
        return this.mode;
    }

    @Nullable
    public final GeoDistanceType distanceType() {
        return this.distanceType;
    }

    @Nullable
    public final Boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Nullable
    public final SortOrder order() {
        return this.order;
    }

    @Nullable
    public final DistanceUnit unit() {
        return this.unit;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        generator.writeStartArray();
        for (GeoLocation item0 : this.location) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
        if (this.distanceType != null) {
            generator.writeKey("distance_type");
            this.distanceType.serialize(generator, mapper);
        }
        if (this.ignoreUnmapped != null) {
            generator.writeKey("ignore_unmapped");
            generator.write(this.ignoreUnmapped);
        }
        if (this.order != null) {
            generator.writeKey("order");
            this.order.serialize(generator, mapper);
        }
        if (this.unit != null) {
            generator.writeKey("unit");
            this.unit.serialize(generator, mapper);
        }
    }

    protected static void setupGeoDistanceSortDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mode, SortMode._DESERIALIZER, "mode");
        op.add(Builder::distanceType, GeoDistanceType._DESERIALIZER, "distance_type");
        op.add(Builder::ignoreUnmapped, JsonpDeserializer.booleanDeserializer(), "ignore_unmapped");
        op.add(Builder::order, SortOrder._DESERIALIZER, "order");
        op.add(Builder::unit, DistanceUnit._DESERIALIZER, "unit");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.location(JsonpDeserializer.arrayDeserializer(GeoLocation._DESERIALIZER).deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GeoDistanceSort> {
        private String field;
        private List<GeoLocation> location;
        @Nullable
        private SortMode mode;
        @Nullable
        private GeoDistanceType distanceType;
        @Nullable
        private Boolean ignoreUnmapped;
        @Nullable
        private SortOrder order;
        @Nullable
        private DistanceUnit unit;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder location(List<GeoLocation> list) {
            this.location = Builder._listAddAll(this.location, list);
            return this;
        }

        public final Builder location(GeoLocation value, GeoLocation ... values) {
            this.location = Builder._listAdd(this.location, value, values);
            return this;
        }

        public final Builder location(Function<GeoLocation.Builder, ObjectBuilder<GeoLocation>> fn) {
            return this.location(fn.apply(new GeoLocation.Builder()).build(), new GeoLocation[0]);
        }

        public final Builder mode(@Nullable SortMode value) {
            this.mode = value;
            return this;
        }

        public final Builder distanceType(@Nullable GeoDistanceType value) {
            this.distanceType = value;
            return this;
        }

        public final Builder ignoreUnmapped(@Nullable Boolean value) {
            this.ignoreUnmapped = value;
            return this;
        }

        public final Builder order(@Nullable SortOrder value) {
            this.order = value;
            return this;
        }

        public final Builder unit(@Nullable DistanceUnit value) {
            this.unit = value;
            return this;
        }

        @Override
        public GeoDistanceSort build() {
            this._checkSingleUse();
            return new GeoDistanceSort(this);
        }
    }
}

