/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ClassificationInferenceOptions
implements PlainJsonSerializable {
    @Nullable
    private final Integer numTopClasses;
    @Nullable
    private final Integer numTopFeatureImportanceValues;
    @Nullable
    private final String predictionFieldType;
    @Nullable
    private final String resultsField;
    @Nullable
    private final String topClassesResultsField;
    public static final JsonpDeserializer<ClassificationInferenceOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClassificationInferenceOptions::setupClassificationInferenceOptionsDeserializer);

    private ClassificationInferenceOptions(Builder builder) {
        this.numTopClasses = builder.numTopClasses;
        this.numTopFeatureImportanceValues = builder.numTopFeatureImportanceValues;
        this.predictionFieldType = builder.predictionFieldType;
        this.resultsField = builder.resultsField;
        this.topClassesResultsField = builder.topClassesResultsField;
    }

    public static ClassificationInferenceOptions of(Function<Builder, ObjectBuilder<ClassificationInferenceOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer numTopClasses() {
        return this.numTopClasses;
    }

    @Nullable
    public final Integer numTopFeatureImportanceValues() {
        return this.numTopFeatureImportanceValues;
    }

    @Nullable
    public final String predictionFieldType() {
        return this.predictionFieldType;
    }

    @Nullable
    public final String resultsField() {
        return this.resultsField;
    }

    @Nullable
    public final String topClassesResultsField() {
        return this.topClassesResultsField;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.numTopClasses != null) {
            generator.writeKey("num_top_classes");
            generator.write(this.numTopClasses);
        }
        if (this.numTopFeatureImportanceValues != null) {
            generator.writeKey("num_top_feature_importance_values");
            generator.write(this.numTopFeatureImportanceValues);
        }
        if (this.predictionFieldType != null) {
            generator.writeKey("prediction_field_type");
            generator.write(this.predictionFieldType);
        }
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
        if (this.topClassesResultsField != null) {
            generator.writeKey("top_classes_results_field");
            generator.write(this.topClassesResultsField);
        }
    }

    protected static void setupClassificationInferenceOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numTopClasses, JsonpDeserializer.integerDeserializer(), "num_top_classes");
        op.add(Builder::numTopFeatureImportanceValues, JsonpDeserializer.integerDeserializer(), "num_top_feature_importance_values");
        op.add(Builder::predictionFieldType, JsonpDeserializer.stringDeserializer(), "prediction_field_type");
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field");
        op.add(Builder::topClassesResultsField, JsonpDeserializer.stringDeserializer(), "top_classes_results_field");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClassificationInferenceOptions> {
        @Nullable
        private Integer numTopClasses;
        @Nullable
        private Integer numTopFeatureImportanceValues;
        @Nullable
        private String predictionFieldType;
        @Nullable
        private String resultsField;
        @Nullable
        private String topClassesResultsField;

        public final Builder numTopClasses(@Nullable Integer value) {
            this.numTopClasses = value;
            return this;
        }

        public final Builder numTopFeatureImportanceValues(@Nullable Integer value) {
            this.numTopFeatureImportanceValues = value;
            return this;
        }

        public final Builder predictionFieldType(@Nullable String value) {
            this.predictionFieldType = value;
            return this;
        }

        public final Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        public final Builder topClassesResultsField(@Nullable String value) {
            this.topClassesResultsField = value;
            return this;
        }

        @Override
        public ClassificationInferenceOptions build() {
            this._checkSingleUse();
            return new ClassificationInferenceOptions(this);
        }
    }
}

