/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class ShingleTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant {
    @Nullable
    private final String fillerToken;
    @Nullable
    private final String maxShingleSize;
    @Nullable
    private final String minShingleSize;
    @Nullable
    private final Boolean outputUnigrams;
    @Nullable
    private final Boolean outputUnigramsIfNoShingles;
    @Nullable
    private final String tokenSeparator;
    public static final JsonpDeserializer<ShingleTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShingleTokenFilter::setupShingleTokenFilterDeserializer);

    private ShingleTokenFilter(Builder builder) {
        super(builder);
        this.fillerToken = builder.fillerToken;
        this.maxShingleSize = builder.maxShingleSize;
        this.minShingleSize = builder.minShingleSize;
        this.outputUnigrams = builder.outputUnigrams;
        this.outputUnigramsIfNoShingles = builder.outputUnigramsIfNoShingles;
        this.tokenSeparator = builder.tokenSeparator;
    }

    public static ShingleTokenFilter of(Function<Builder, ObjectBuilder<ShingleTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.Shingle;
    }

    @Nullable
    public final String fillerToken() {
        return this.fillerToken;
    }

    @Nullable
    public final String maxShingleSize() {
        return this.maxShingleSize;
    }

    @Nullable
    public final String minShingleSize() {
        return this.minShingleSize;
    }

    @Nullable
    public final Boolean outputUnigrams() {
        return this.outputUnigrams;
    }

    @Nullable
    public final Boolean outputUnigramsIfNoShingles() {
        return this.outputUnigramsIfNoShingles;
    }

    @Nullable
    public final String tokenSeparator() {
        return this.tokenSeparator;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "shingle");
        super.serializeInternal(generator, mapper);
        if (this.fillerToken != null) {
            generator.writeKey("filler_token");
            generator.write(this.fillerToken);
        }
        if (this.maxShingleSize != null) {
            generator.writeKey("max_shingle_size");
            generator.write(this.maxShingleSize);
        }
        if (this.minShingleSize != null) {
            generator.writeKey("min_shingle_size");
            generator.write(this.minShingleSize);
        }
        if (this.outputUnigrams != null) {
            generator.writeKey("output_unigrams");
            generator.write(this.outputUnigrams);
        }
        if (this.outputUnigramsIfNoShingles != null) {
            generator.writeKey("output_unigrams_if_no_shingles");
            generator.write(this.outputUnigramsIfNoShingles);
        }
        if (this.tokenSeparator != null) {
            generator.writeKey("token_separator");
            generator.write(this.tokenSeparator);
        }
    }

    protected static void setupShingleTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        ShingleTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::fillerToken, JsonpDeserializer.stringDeserializer(), "filler_token");
        op.add(Builder::maxShingleSize, JsonpDeserializer.stringDeserializer(), "max_shingle_size");
        op.add(Builder::minShingleSize, JsonpDeserializer.stringDeserializer(), "min_shingle_size");
        op.add(Builder::outputUnigrams, JsonpDeserializer.booleanDeserializer(), "output_unigrams");
        op.add(Builder::outputUnigramsIfNoShingles, JsonpDeserializer.booleanDeserializer(), "output_unigrams_if_no_shingles");
        op.add(Builder::tokenSeparator, JsonpDeserializer.stringDeserializer(), "token_separator");
        op.ignore("type");
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ShingleTokenFilter> {
        @Nullable
        private String fillerToken;
        @Nullable
        private String maxShingleSize;
        @Nullable
        private String minShingleSize;
        @Nullable
        private Boolean outputUnigrams;
        @Nullable
        private Boolean outputUnigramsIfNoShingles;
        @Nullable
        private String tokenSeparator;

        public final Builder fillerToken(@Nullable String value) {
            this.fillerToken = value;
            return this;
        }

        public final Builder maxShingleSize(@Nullable String value) {
            this.maxShingleSize = value;
            return this;
        }

        public final Builder minShingleSize(@Nullable String value) {
            this.minShingleSize = value;
            return this;
        }

        public final Builder outputUnigrams(@Nullable Boolean value) {
            this.outputUnigrams = value;
            return this;
        }

        public final Builder outputUnigramsIfNoShingles(@Nullable Boolean value) {
            this.outputUnigramsIfNoShingles = value;
            return this;
        }

        public final Builder tokenSeparator(@Nullable String value) {
            this.tokenSeparator = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ShingleTokenFilter build() {
            this._checkSingleUse();
            return new ShingleTokenFilter(this);
        }
    }
}

