/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.opensearch._types.mapping.StandardNumberProperty;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class HalfFloatNumberProperty
extends StandardNumberProperty
implements PropertyVariant {
    @Nullable
    private final Float nullValue;
    public static final JsonpDeserializer<HalfFloatNumberProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HalfFloatNumberProperty::setupHalfFloatNumberPropertyDeserializer);

    private HalfFloatNumberProperty(Builder builder) {
        super(builder);
        this.nullValue = builder.nullValue;
    }

    public static HalfFloatNumberProperty of(Function<Builder, ObjectBuilder<HalfFloatNumberProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.HalfFloat;
    }

    @Nullable
    public final Float nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "half_float");
        super.serializeInternal(generator, mapper);
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue.floatValue());
        }
    }

    protected static void setupHalfFloatNumberPropertyDeserializer(ObjectDeserializer<Builder> op) {
        StandardNumberProperty.setupStandardNumberPropertyDeserializer(op);
        op.add(Builder::nullValue, JsonpDeserializer.floatDeserializer(), "null_value");
        op.ignore("type");
    }

    public static class Builder
    extends StandardNumberProperty.AbstractBuilder<Builder>
    implements ObjectBuilder<HalfFloatNumberProperty> {
        @Nullable
        private Float nullValue;

        public final Builder nullValue(@Nullable Float value) {
            this.nullValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HalfFloatNumberProperty build() {
            this._checkSingleUse();
            return new HalfFloatNumberProperty(this);
        }
    }
}

