/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyBase;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class HistogramProperty
extends PropertyBase
implements PropertyVariant {
    @Nullable
    private final Boolean ignoreMalformed;
    public static final JsonpDeserializer<HistogramProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HistogramProperty::setupHistogramPropertyDeserializer);

    private HistogramProperty(Builder builder) {
        super(builder);
        this.ignoreMalformed = builder.ignoreMalformed;
    }

    public static HistogramProperty of(Function<Builder, ObjectBuilder<HistogramProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Histogram;
    }

    @Nullable
    public final Boolean ignoreMalformed() {
        return this.ignoreMalformed;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "histogram");
        super.serializeInternal(generator, mapper);
        if (this.ignoreMalformed != null) {
            generator.writeKey("ignore_malformed");
            generator.write(this.ignoreMalformed);
        }
    }

    protected static void setupHistogramPropertyDeserializer(ObjectDeserializer<Builder> op) {
        PropertyBase.setupPropertyBaseDeserializer(op);
        op.add(Builder::ignoreMalformed, JsonpDeserializer.booleanDeserializer(), "ignore_malformed");
        op.ignore("type");
    }

    public static class Builder
    extends PropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<HistogramProperty> {
        @Nullable
        private Boolean ignoreMalformed;

        public final Builder ignoreMalformed(@Nullable Boolean value) {
            this.ignoreMalformed = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public HistogramProperty build() {
            this._checkSingleUse();
            return new HistogramProperty(this);
        }
    }
}

