/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster.allocation_explain;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.cluster.allocation_explain.NodeDiskUsage;
import org.opensearch.client.opensearch.cluster.allocation_explain.ReservedSize;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class ClusterInfo
implements PlainJsonSerializable {
    private final Map<String, NodeDiskUsage> nodes;
    private final Map<String, Long> shardSizes;
    private final Map<String, String> shardDataSetSizes;
    private final Map<String, String> shardPaths;
    private final List<ReservedSize> reservedSizes;
    public static final JsonpDeserializer<ClusterInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClusterInfo::setupClusterInfoDeserializer);

    private ClusterInfo(Builder builder) {
        this.nodes = ApiTypeHelper.unmodifiableRequired(builder.nodes, (Object)this, "nodes");
        this.shardSizes = ApiTypeHelper.unmodifiableRequired(builder.shardSizes, (Object)this, "shardSizes");
        this.shardDataSetSizes = ApiTypeHelper.unmodifiable(builder.shardDataSetSizes);
        this.shardPaths = ApiTypeHelper.unmodifiableRequired(builder.shardPaths, (Object)this, "shardPaths");
        this.reservedSizes = ApiTypeHelper.unmodifiableRequired(builder.reservedSizes, (Object)this, "reservedSizes");
    }

    public static ClusterInfo of(Function<Builder, ObjectBuilder<ClusterInfo>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, NodeDiskUsage> nodes() {
        return this.nodes;
    }

    public final Map<String, Long> shardSizes() {
        return this.shardSizes;
    }

    public final Map<String, String> shardDataSetSizes() {
        return this.shardDataSetSizes;
    }

    public final Map<String, String> shardPaths() {
        return this.shardPaths;
    }

    public final List<ReservedSize> reservedSizes() {
        return this.reservedSizes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.nodes)) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry<String, NodeDiskUsage> entry : this.nodes.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.shardSizes)) {
            generator.writeKey("shard_sizes");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.shardSizes.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write((Long)entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.shardDataSetSizes)) {
            generator.writeKey("shard_data_set_sizes");
            generator.writeStartObject();
            for (Map.Entry<String, Object> entry : this.shardDataSetSizes.entrySet()) {
                generator.writeKey(entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.shardPaths)) {
            generator.writeKey("shard_paths");
            generator.writeStartObject();
            for (Map.Entry entry : this.shardPaths.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.reservedSizes)) {
            generator.writeKey("reserved_sizes");
            generator.writeStartArray();
            for (ReservedSize reservedSize : this.reservedSizes) {
                reservedSize.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupClusterInfoDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(NodeDiskUsage._DESERIALIZER), "nodes");
        op.add(Builder::shardSizes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "shard_sizes");
        op.add(Builder::shardDataSetSizes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "shard_data_set_sizes");
        op.add(Builder::shardPaths, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "shard_paths");
        op.add(Builder::reservedSizes, JsonpDeserializer.arrayDeserializer(ReservedSize._DESERIALIZER), "reserved_sizes");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ClusterInfo> {
        private Map<String, NodeDiskUsage> nodes;
        private Map<String, Long> shardSizes;
        @Nullable
        private Map<String, String> shardDataSetSizes;
        private Map<String, String> shardPaths;
        private List<ReservedSize> reservedSizes;

        public final Builder nodes(Map<String, NodeDiskUsage> map) {
            this.nodes = Builder._mapPutAll(this.nodes, map);
            return this;
        }

        public final Builder nodes(String key, NodeDiskUsage value) {
            this.nodes = Builder._mapPut(this.nodes, key, value);
            return this;
        }

        public final Builder nodes(String key, Function<NodeDiskUsage.Builder, ObjectBuilder<NodeDiskUsage>> fn) {
            return this.nodes(key, fn.apply(new NodeDiskUsage.Builder()).build());
        }

        public final Builder shardSizes(Map<String, Long> map) {
            this.shardSizes = Builder._mapPutAll(this.shardSizes, map);
            return this;
        }

        public final Builder shardSizes(String key, Long value) {
            this.shardSizes = Builder._mapPut(this.shardSizes, key, value);
            return this;
        }

        public final Builder shardDataSetSizes(Map<String, String> map) {
            this.shardDataSetSizes = Builder._mapPutAll(this.shardDataSetSizes, map);
            return this;
        }

        public final Builder shardDataSetSizes(String key, String value) {
            this.shardDataSetSizes = Builder._mapPut(this.shardDataSetSizes, key, value);
            return this;
        }

        public final Builder shardPaths(Map<String, String> map) {
            this.shardPaths = Builder._mapPutAll(this.shardPaths, map);
            return this;
        }

        public final Builder shardPaths(String key, String value) {
            this.shardPaths = Builder._mapPut(this.shardPaths, key, value);
            return this;
        }

        public final Builder reservedSizes(List<ReservedSize> list) {
            this.reservedSizes = Builder._listAddAll(this.reservedSizes, list);
            return this;
        }

        public final Builder reservedSizes(ReservedSize value, ReservedSize ... values) {
            this.reservedSizes = Builder._listAdd(this.reservedSizes, value, values);
            return this;
        }

        public final Builder reservedSizes(Function<ReservedSize.Builder, ObjectBuilder<ReservedSize>> fn) {
            return this.reservedSizes(fn.apply(new ReservedSize.Builder()).build(), new ReservedSize[0]);
        }

        @Override
        public ClusterInfo build() {
            this._checkSingleUse();
            return new ClusterInfo(this);
        }
    }
}

