/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.msearch;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.SearchResult;
import org.opensearch.client.util.ObjectBuilder;

public class MultiSearchItem<TDocument>
extends SearchResponse<TDocument> {
    @Nullable
    private final Integer status;

    private MultiSearchItem(Builder<TDocument> builder) {
        super(builder);
        this.status = ((Builder)builder).status;
    }

    public static <TDocument> MultiSearchItem<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<MultiSearchItem<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer status() {
        return this.status;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.status != null) {
            generator.writeKey("status");
            generator.write(this.status);
        }
    }

    public static <TDocument> JsonpDeserializer<MultiSearchItem<TDocument>> createMultiSearchItemDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> MultiSearchItem.setupMultiSearchItemDeserializer(op, tDocumentDeserializer));
    }

    protected static <TDocument> void setupMultiSearchItemDeserializer(ObjectDeserializer<Builder<TDocument>> op, JsonpDeserializer<TDocument> tDocumentDeserializer) {
        SearchResponse.setupSearchResponseDeserializer(op, tDocumentDeserializer);
        op.add(Builder::status, JsonpDeserializer.integerDeserializer(), "status");
    }

    public static class Builder<TDocument>
    extends SearchResult.AbstractBuilder<TDocument, Builder<TDocument>>
    implements ObjectBuilder<MultiSearchItem<TDocument>> {
        @Nullable
        private Integer status;

        public final Builder<TDocument> status(@Nullable Integer value) {
            this.status = value;
            return this;
        }

        @Override
        protected Builder<TDocument> self() {
            return this;
        }

        @Override
        public MultiSearchItem<TDocument> build() {
            this._checkSingleUse();
            return new MultiSearchItem(this);
        }
    }
}

