/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.search;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.SuggestMode;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class DirectGenerator
implements PlainJsonSerializable {
    private final String field;
    @Nullable
    private final Integer maxEdits;
    @Nullable
    private final Float maxInspections;
    @Nullable
    private final Float maxTermFreq;
    @Nullable
    private final Float minDocFreq;
    @Nullable
    private final Integer minWordLength;
    @Nullable
    private final String postFilter;
    @Nullable
    private final String preFilter;
    @Nullable
    private final Integer prefixLength;
    @Nullable
    private final Integer size;
    @Nullable
    private final SuggestMode suggestMode;
    public static final JsonpDeserializer<DirectGenerator> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DirectGenerator::setupDirectGeneratorDeserializer);

    private DirectGenerator(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.maxEdits = builder.maxEdits;
        this.maxInspections = builder.maxInspections;
        this.maxTermFreq = builder.maxTermFreq;
        this.minDocFreq = builder.minDocFreq;
        this.minWordLength = builder.minWordLength;
        this.postFilter = builder.postFilter;
        this.preFilter = builder.preFilter;
        this.prefixLength = builder.prefixLength;
        this.size = builder.size;
        this.suggestMode = builder.suggestMode;
    }

    public static DirectGenerator of(Function<Builder, ObjectBuilder<DirectGenerator>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Integer maxEdits() {
        return this.maxEdits;
    }

    @Nullable
    public final Float maxInspections() {
        return this.maxInspections;
    }

    @Nullable
    public final Float maxTermFreq() {
        return this.maxTermFreq;
    }

    @Nullable
    public final Float minDocFreq() {
        return this.minDocFreq;
    }

    @Nullable
    public final Integer minWordLength() {
        return this.minWordLength;
    }

    @Nullable
    public final String postFilter() {
        return this.postFilter;
    }

    @Nullable
    public final String preFilter() {
        return this.preFilter;
    }

    @Nullable
    public final Integer prefixLength() {
        return this.prefixLength;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final SuggestMode suggestMode() {
        return this.suggestMode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("field");
        generator.write(this.field);
        if (this.maxEdits != null) {
            generator.writeKey("max_edits");
            generator.write(this.maxEdits);
        }
        if (this.maxInspections != null) {
            generator.writeKey("max_inspections");
            generator.write(this.maxInspections.floatValue());
        }
        if (this.maxTermFreq != null) {
            generator.writeKey("max_term_freq");
            generator.write(this.maxTermFreq.floatValue());
        }
        if (this.minDocFreq != null) {
            generator.writeKey("min_doc_freq");
            generator.write(this.minDocFreq.floatValue());
        }
        if (this.minWordLength != null) {
            generator.writeKey("min_word_length");
            generator.write(this.minWordLength);
        }
        if (this.postFilter != null) {
            generator.writeKey("post_filter");
            generator.write(this.postFilter);
        }
        if (this.preFilter != null) {
            generator.writeKey("pre_filter");
            generator.write(this.preFilter);
        }
        if (this.prefixLength != null) {
            generator.writeKey("prefix_length");
            generator.write(this.prefixLength);
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size);
        }
        if (this.suggestMode != null) {
            generator.writeKey("suggest_mode");
            this.suggestMode.serialize(generator, mapper);
        }
    }

    protected static void setupDirectGeneratorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::maxEdits, JsonpDeserializer.integerDeserializer(), "max_edits");
        op.add(Builder::maxInspections, JsonpDeserializer.floatDeserializer(), "max_inspections");
        op.add(Builder::maxTermFreq, JsonpDeserializer.floatDeserializer(), "max_term_freq");
        op.add(Builder::minDocFreq, JsonpDeserializer.floatDeserializer(), "min_doc_freq");
        op.add(Builder::minWordLength, JsonpDeserializer.integerDeserializer(), "min_word_length");
        op.add(Builder::postFilter, JsonpDeserializer.stringDeserializer(), "post_filter");
        op.add(Builder::preFilter, JsonpDeserializer.stringDeserializer(), "pre_filter");
        op.add(Builder::prefixLength, JsonpDeserializer.integerDeserializer(), "prefix_length");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::suggestMode, SuggestMode._DESERIALIZER, "suggest_mode");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<DirectGenerator> {
        private String field;
        @Nullable
        private Integer maxEdits;
        @Nullable
        private Float maxInspections;
        @Nullable
        private Float maxTermFreq;
        @Nullable
        private Float minDocFreq;
        @Nullable
        private Integer minWordLength;
        @Nullable
        private String postFilter;
        @Nullable
        private String preFilter;
        @Nullable
        private Integer prefixLength;
        @Nullable
        private Integer size;
        @Nullable
        private SuggestMode suggestMode;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder maxEdits(@Nullable Integer value) {
            this.maxEdits = value;
            return this;
        }

        public final Builder maxInspections(@Nullable Float value) {
            this.maxInspections = value;
            return this;
        }

        public final Builder maxTermFreq(@Nullable Float value) {
            this.maxTermFreq = value;
            return this;
        }

        public final Builder minDocFreq(@Nullable Float value) {
            this.minDocFreq = value;
            return this;
        }

        public final Builder minWordLength(@Nullable Integer value) {
            this.minWordLength = value;
            return this;
        }

        public final Builder postFilter(@Nullable String value) {
            this.postFilter = value;
            return this;
        }

        public final Builder preFilter(@Nullable String value) {
            this.preFilter = value;
            return this;
        }

        public final Builder prefixLength(@Nullable Integer value) {
            this.prefixLength = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder suggestMode(@Nullable SuggestMode value) {
            this.suggestMode = value;
            return this;
        }

        @Override
        public DirectGenerator build() {
            this._checkSingleUse();
            return new DirectGenerator(this);
        }
    }
}

