/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal;

import jakarta.json.bind.JsonbException;
import jakarta.json.bind.serializer.JsonbSerializer;
import jakarta.json.bind.serializer.SerializationContext;
import jakarta.json.stream.JsonGenerationException;
import jakarta.json.stream.JsonGenerator;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.yasson.internal.JsonbContext;
import org.eclipse.yasson.internal.ProcessingContext;
import org.eclipse.yasson.internal.model.ClassModel;
import org.eclipse.yasson.internal.model.JsonbPropertyInfo;
import org.eclipse.yasson.internal.properties.MessageKeys;
import org.eclipse.yasson.internal.properties.Messages;
import org.eclipse.yasson.internal.serializer.AbstractValueTypeSerializer;
import org.eclipse.yasson.internal.serializer.ContainerSerializerProvider;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class Marshaller
extends ProcessingContext
implements SerializationContext {
    private static final Logger LOGGER = Logger.getLogger(Marshaller.class.getName());
    private final Type runtimeType;

    public Marshaller(JsonbContext jsonbContext, Type rootRuntimeType) {
        super(jsonbContext);
        this.runtimeType = rootRuntimeType;
    }

    public Marshaller(JsonbContext jsonbContext) {
        super(jsonbContext);
        this.runtimeType = null;
    }

    public void marshall(Object object, JsonGenerator jsonGenerator, boolean close) {
        try {
            this.serializeRoot(object, jsonGenerator);
        }
        catch (JsonbException e) {
            LOGGER.severe(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
            throw new JsonbException(Messages.getMessage(MessageKeys.INTERNAL_ERROR, e.getMessage()), e);
        }
        finally {
            try {
                if (close) {
                    jsonGenerator.close();
                } else {
                    jsonGenerator.flush();
                }
            }
            catch (JsonGenerationException jge) {
                LOGGER.severe(jge.getMessage());
            }
        }
    }

    public void marshall(Object object, JsonGenerator jsonGenerator) {
        this.marshall(object, jsonGenerator, true);
    }

    public void marshallWithoutClose(Object object, JsonGenerator jsonGenerator) {
        this.marshall(object, jsonGenerator, false);
    }

    @Override
    public <T> void serialize(String key, T object, JsonGenerator generator) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(object);
        generator.writeKey(key);
        this.serializeRoot(object, generator);
    }

    @Override
    public <T> void serialize(T object, JsonGenerator generator) {
        Objects.requireNonNull(object);
        this.serializeRoot(object, generator);
    }

    public <T> void serializeRoot(T root, JsonGenerator generator) {
        if (root == null) {
            this.getJsonbContext().getConfigProperties().getNullSerializer().serialize(null, generator, this);
            return;
        }
        JsonbSerializer<?> rootSerializer = this.getRootSerializer(root.getClass());
        if (this.getJsonbContext().getConfigProperties().isStrictIJson() && rootSerializer instanceof AbstractValueTypeSerializer) {
            throw new JsonbException(Messages.getMessage(MessageKeys.IJSON_ENABLED_SINGLE_VALUE, new Object[0]));
        }
        rootSerializer.serialize(root, generator, this);
    }

    JsonbSerializer<?> getRootSerializer(Class<?> rootClazz) {
        ContainerSerializerProvider serializerProvider = this.getMappingContext().getSerializerProvider(rootClazz);
        if (serializerProvider != null) {
            return serializerProvider.provideSerializer(new JsonbPropertyInfo().withRuntimeType(this.runtimeType));
        }
        SerializerBuilder serializerBuilder = (SerializerBuilder)new SerializerBuilder(this.getJsonbContext()).withObjectClass(rootClazz).withType(this.runtimeType);
        ClassModel classModel = this.getMappingContext().getOrCreateClassModel(rootClazz);
        serializerBuilder.withCustomization(classModel.getClassCustomization());
        return serializerBuilder.build();
    }
}

