/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch._types.GeoHashLocation;
import org.opensearch.client.opensearch._types.LatLonGeoLocation;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

@JsonpDeserializable
public class GeoLocation
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<GeoLocation> _DESERIALIZER = JsonpDeserializer.lazy(GeoLocation::buildGeoLocationDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private GeoLocation(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private GeoLocation(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static GeoLocation of(Function<Builder, ObjectBuilder<GeoLocation>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isCoords() {
        return this._kind == Kind.Coords;
    }

    public List<Double> coords() {
        return (List)TaggedUnionUtils.get(this, Kind.Coords);
    }

    public boolean isGeohash() {
        return this._kind == Kind.Geohash;
    }

    public GeoHashLocation geohash() {
        return (GeoHashLocation)TaggedUnionUtils.get(this, Kind.Geohash);
    }

    public boolean isLatlon() {
        return this._kind == Kind.Latlon;
    }

    public LatLonGeoLocation latlon() {
        return (LatLonGeoLocation)TaggedUnionUtils.get(this, Kind.Latlon);
    }

    public boolean isText() {
        return this._kind == Kind.Text;
    }

    public String text() {
        return (String)TaggedUnionUtils.get(this, Kind.Text);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Coords: {
                    generator.writeStartArray();
                    for (Double item0 : (List)this._value) {
                        generator.write(item0);
                    }
                    generator.writeEnd();
                    break;
                }
                case Text: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    private static JsonpDeserializer<GeoLocation> buildGeoLocationDeserializer() {
        return new UnionDeserializer.Builder<GeoLocation, Kind, Object>(GeoLocation::new, false).addMember(Kind.Coords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer())).addMember(Kind.Geohash, GeoHashLocation._DESERIALIZER).addMember(Kind.Latlon, LatLonGeoLocation._DESERIALIZER).addMember(Kind.Text, JsonpDeserializer.stringDeserializer()).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GeoLocation> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<GeoLocation> coords(List<Double> v) {
            this._kind = Kind.Coords;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoLocation> geohash(GeoHashLocation v) {
            this._kind = Kind.Geohash;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoLocation> geohash(Function<GeoHashLocation.Builder, ObjectBuilder<GeoHashLocation>> fn) {
            return this.geohash(fn.apply(new GeoHashLocation.Builder()).build());
        }

        public ObjectBuilder<GeoLocation> latlon(LatLonGeoLocation v) {
            this._kind = Kind.Latlon;
            this._value = v;
            return this;
        }

        public ObjectBuilder<GeoLocation> latlon(Function<LatLonGeoLocation.Builder, ObjectBuilder<LatLonGeoLocation>> fn) {
            return this.latlon(fn.apply(new LatLonGeoLocation.Builder()).build());
        }

        public ObjectBuilder<GeoLocation> text(String v) {
            this._kind = Kind.Text;
            this._value = v;
            return this;
        }

        @Override
        public GeoLocation build() {
            this._checkSingleUse();
            return new GeoLocation(this);
        }
    }

    public static enum Kind {
        Coords,
        Geohash,
        Latlon,
        Text;

    }
}

