/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.util.ApiTypeHelper;

public abstract class CompoundWordTokenFilterBase
extends TokenFilterBase {
    @Nullable
    private final String hyphenationPatternsPath;
    @Nullable
    private final Integer maxSubwordSize;
    @Nullable
    private final Integer minSubwordSize;
    @Nullable
    private final Integer minWordSize;
    @Nullable
    private final Boolean onlyLongestMatch;
    private final List<String> wordList;
    @Nullable
    private final String wordListPath;

    protected CompoundWordTokenFilterBase(AbstractBuilder<?> builder) {
        super(builder);
        this.hyphenationPatternsPath = ((AbstractBuilder)builder).hyphenationPatternsPath;
        this.maxSubwordSize = ((AbstractBuilder)builder).maxSubwordSize;
        this.minSubwordSize = ((AbstractBuilder)builder).minSubwordSize;
        this.minWordSize = ((AbstractBuilder)builder).minWordSize;
        this.onlyLongestMatch = ((AbstractBuilder)builder).onlyLongestMatch;
        this.wordList = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).wordList);
        this.wordListPath = ((AbstractBuilder)builder).wordListPath;
    }

    @Nullable
    public final String hyphenationPatternsPath() {
        return this.hyphenationPatternsPath;
    }

    @Nullable
    public final Integer maxSubwordSize() {
        return this.maxSubwordSize;
    }

    @Nullable
    public final Integer minSubwordSize() {
        return this.minSubwordSize;
    }

    @Nullable
    public final Integer minWordSize() {
        return this.minWordSize;
    }

    @Nullable
    public final Boolean onlyLongestMatch() {
        return this.onlyLongestMatch;
    }

    public final List<String> wordList() {
        return this.wordList;
    }

    @Nullable
    public final String wordListPath() {
        return this.wordListPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.hyphenationPatternsPath != null) {
            generator.writeKey("hyphenation_patterns_path");
            generator.write(this.hyphenationPatternsPath);
        }
        if (this.maxSubwordSize != null) {
            generator.writeKey("max_subword_size");
            generator.write(this.maxSubwordSize);
        }
        if (this.minSubwordSize != null) {
            generator.writeKey("min_subword_size");
            generator.write(this.minSubwordSize);
        }
        if (this.minWordSize != null) {
            generator.writeKey("min_word_size");
            generator.write(this.minWordSize);
        }
        if (this.onlyLongestMatch != null) {
            generator.writeKey("only_longest_match");
            generator.write(this.onlyLongestMatch);
        }
        if (ApiTypeHelper.isDefined(this.wordList)) {
            generator.writeKey("word_list");
            generator.writeStartArray();
            for (String item0 : this.wordList) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.wordListPath != null) {
            generator.writeKey("word_list_path");
            generator.write(this.wordListPath);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupCompoundWordTokenFilterBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(AbstractBuilder::hyphenationPatternsPath, JsonpDeserializer.stringDeserializer(), "hyphenation_patterns_path");
        op.add(AbstractBuilder::maxSubwordSize, JsonpDeserializer.integerDeserializer(), "max_subword_size");
        op.add(AbstractBuilder::minSubwordSize, JsonpDeserializer.integerDeserializer(), "min_subword_size");
        op.add(AbstractBuilder::minWordSize, JsonpDeserializer.integerDeserializer(), "min_word_size");
        op.add(AbstractBuilder::onlyLongestMatch, JsonpDeserializer.booleanDeserializer(), "only_longest_match");
        op.add(AbstractBuilder::wordList, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "word_list");
        op.add(AbstractBuilder::wordListPath, JsonpDeserializer.stringDeserializer(), "word_list_path");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends TokenFilterBase.AbstractBuilder<BuilderT> {
        @Nullable
        private String hyphenationPatternsPath;
        @Nullable
        private Integer maxSubwordSize;
        @Nullable
        private Integer minSubwordSize;
        @Nullable
        private Integer minWordSize;
        @Nullable
        private Boolean onlyLongestMatch;
        @Nullable
        private List<String> wordList;
        @Nullable
        private String wordListPath;

        protected AbstractBuilder() {
        }

        public final BuilderT hyphenationPatternsPath(@Nullable String value) {
            this.hyphenationPatternsPath = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT maxSubwordSize(@Nullable Integer value) {
            this.maxSubwordSize = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT minSubwordSize(@Nullable Integer value) {
            this.minSubwordSize = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT minWordSize(@Nullable Integer value) {
            this.minWordSize = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT onlyLongestMatch(@Nullable Boolean value) {
            this.onlyLongestMatch = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT wordList(List<String> list) {
            this.wordList = AbstractBuilder._listAddAll(this.wordList, list);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT wordList(String value, String ... values) {
            this.wordList = AbstractBuilder._listAdd(this.wordList, value, values);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT wordListPath(@Nullable String value) {
            this.wordListPath = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

