/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.NoriDecompoundMode;
import org.opensearch.client.opensearch._types.analysis.TokenizerBase;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class NoriTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant {
    @Nullable
    private final NoriDecompoundMode decompoundMode;
    @Nullable
    private final Boolean discardPunctuation;
    @Nullable
    private final String userDictionary;
    private final List<String> userDictionaryRules;
    public static final JsonpDeserializer<NoriTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NoriTokenizer::setupNoriTokenizerDeserializer);

    private NoriTokenizer(Builder builder) {
        super(builder);
        this.decompoundMode = builder.decompoundMode;
        this.discardPunctuation = builder.discardPunctuation;
        this.userDictionary = builder.userDictionary;
        this.userDictionaryRules = ApiTypeHelper.unmodifiable(builder.userDictionaryRules);
    }

    public static NoriTokenizer of(Function<Builder, ObjectBuilder<NoriTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.NoriTokenizer;
    }

    @Nullable
    public final NoriDecompoundMode decompoundMode() {
        return this.decompoundMode;
    }

    @Nullable
    public final Boolean discardPunctuation() {
        return this.discardPunctuation;
    }

    @Nullable
    public final String userDictionary() {
        return this.userDictionary;
    }

    public final List<String> userDictionaryRules() {
        return this.userDictionaryRules;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "nori_tokenizer");
        super.serializeInternal(generator, mapper);
        if (this.decompoundMode != null) {
            generator.writeKey("decompound_mode");
            this.decompoundMode.serialize(generator, mapper);
        }
        if (this.discardPunctuation != null) {
            generator.writeKey("discard_punctuation");
            generator.write(this.discardPunctuation);
        }
        if (this.userDictionary != null) {
            generator.writeKey("user_dictionary");
            generator.write(this.userDictionary);
        }
        if (ApiTypeHelper.isDefined(this.userDictionaryRules)) {
            generator.writeKey("user_dictionary_rules");
            generator.writeStartArray();
            for (String item0 : this.userDictionaryRules) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupNoriTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        TokenizerBase.setupTokenizerBaseDeserializer(op);
        op.add(Builder::decompoundMode, NoriDecompoundMode._DESERIALIZER, "decompound_mode");
        op.add(Builder::discardPunctuation, JsonpDeserializer.booleanDeserializer(), "discard_punctuation");
        op.add(Builder::userDictionary, JsonpDeserializer.stringDeserializer(), "user_dictionary");
        op.add(Builder::userDictionaryRules, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "user_dictionary_rules");
        op.ignore("type");
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements ObjectBuilder<NoriTokenizer> {
        @Nullable
        private NoriDecompoundMode decompoundMode;
        @Nullable
        private Boolean discardPunctuation;
        @Nullable
        private String userDictionary;
        @Nullable
        private List<String> userDictionaryRules;

        public final Builder decompoundMode(@Nullable NoriDecompoundMode value) {
            this.decompoundMode = value;
            return this;
        }

        public final Builder discardPunctuation(@Nullable Boolean value) {
            this.discardPunctuation = value;
            return this;
        }

        public final Builder userDictionary(@Nullable String value) {
            this.userDictionary = value;
            return this;
        }

        public final Builder userDictionaryRules(List<String> list) {
            this.userDictionaryRules = Builder._listAddAll(this.userDictionaryRules, list);
            return this;
        }

        public final Builder userDictionaryRules(String value, String ... values) {
            this.userDictionaryRules = Builder._listAdd(this.userDictionaryRules, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public NoriTokenizer build() {
            this._checkSingleUse();
            return new NoriTokenizer(this);
        }
    }
}

