/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.mapping;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.mapping.DocValuesPropertyBase;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.PropertyVariant;
import org.opensearch.client.opensearch.indices.NumericFielddata;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class BooleanProperty
extends DocValuesPropertyBase
implements PropertyVariant {
    @Nullable
    private final Double boost;
    @Nullable
    private final NumericFielddata fielddata;
    @Nullable
    private final Boolean index;
    @Nullable
    private final Boolean nullValue;
    public static final JsonpDeserializer<BooleanProperty> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BooleanProperty::setupBooleanPropertyDeserializer);

    private BooleanProperty(Builder builder) {
        super(builder);
        this.boost = builder.boost;
        this.fielddata = builder.fielddata;
        this.index = builder.index;
        this.nullValue = builder.nullValue;
    }

    public static BooleanProperty of(Function<Builder, ObjectBuilder<BooleanProperty>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Property.Kind _propertyKind() {
        return Property.Kind.Boolean;
    }

    @Nullable
    public final Double boost() {
        return this.boost;
    }

    @Nullable
    public final NumericFielddata fielddata() {
        return this.fielddata;
    }

    @Nullable
    public final Boolean index() {
        return this.index;
    }

    @Nullable
    public final Boolean nullValue() {
        return this.nullValue;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "boolean");
        super.serializeInternal(generator, mapper);
        if (this.boost != null) {
            generator.writeKey("boost");
            generator.write(this.boost);
        }
        if (this.fielddata != null) {
            generator.writeKey("fielddata");
            this.fielddata.serialize(generator, mapper);
        }
        if (this.index != null) {
            generator.writeKey("index");
            generator.write(this.index);
        }
        if (this.nullValue != null) {
            generator.writeKey("null_value");
            generator.write(this.nullValue);
        }
    }

    protected static void setupBooleanPropertyDeserializer(ObjectDeserializer<Builder> op) {
        BooleanProperty.setupDocValuesPropertyBaseDeserializer(op);
        op.add(Builder::boost, JsonpDeserializer.doubleDeserializer(), "boost");
        op.add(Builder::fielddata, NumericFielddata._DESERIALIZER, "fielddata");
        op.add(Builder::index, JsonpDeserializer.booleanDeserializer(), "index");
        op.add(Builder::nullValue, JsonpDeserializer.booleanDeserializer(), "null_value");
        op.ignore("type");
    }

    public static class Builder
    extends DocValuesPropertyBase.AbstractBuilder<Builder>
    implements ObjectBuilder<BooleanProperty> {
        @Nullable
        private Double boost;
        @Nullable
        private NumericFielddata fielddata;
        @Nullable
        private Boolean index;
        @Nullable
        private Boolean nullValue;

        public final Builder boost(@Nullable Double value) {
            this.boost = value;
            return this;
        }

        public final Builder fielddata(@Nullable NumericFielddata value) {
            this.fielddata = value;
            return this;
        }

        public final Builder fielddata(Function<NumericFielddata.Builder, ObjectBuilder<NumericFielddata>> fn) {
            return this.fielddata(fn.apply(new NumericFielddata.Builder()).build());
        }

        public final Builder index(@Nullable Boolean value) {
            this.index = value;
            return this;
        }

        public final Builder nullValue(@Nullable Boolean value) {
            this.nullValue = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public BooleanProperty build() {
            this._checkSingleUse();
            return new BooleanProperty(this);
        }
    }
}

