/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBase;
import org.opensearch.client.opensearch._types.query_dsl.QueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class RegexpQuery
extends QueryBase
implements QueryVariant {
    private final String field;
    @Nullable
    private final Boolean caseInsensitive;
    @Nullable
    private final String flags;
    @Nullable
    private final Integer maxDeterminizedStates;
    @Nullable
    private final String rewrite;
    private final String value;
    public static final JsonpDeserializer<RegexpQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RegexpQuery::setupRegexpQueryDeserializer);

    private RegexpQuery(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.caseInsensitive = builder.caseInsensitive;
        this.flags = builder.flags;
        this.maxDeterminizedStates = builder.maxDeterminizedStates;
        this.rewrite = builder.rewrite;
        this.value = ApiTypeHelper.requireNonNull(builder.value, this, "value");
    }

    public static RegexpQuery of(Function<Builder, ObjectBuilder<RegexpQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Query.Kind _queryKind() {
        return Query.Kind.Regexp;
    }

    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    @Nullable
    public final String flags() {
        return this.flags;
    }

    @Nullable
    public final Integer maxDeterminizedStates() {
        return this.maxDeterminizedStates;
    }

    @Nullable
    public final String rewrite() {
        return this.rewrite;
    }

    public final String value() {
        return this.value;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject(this.field);
        super.serializeInternal(generator, mapper);
        if (this.caseInsensitive != null) {
            generator.writeKey("case_insensitive");
            generator.write(this.caseInsensitive);
        }
        if (this.flags != null) {
            generator.writeKey("flags");
            generator.write(this.flags);
        }
        if (this.maxDeterminizedStates != null) {
            generator.writeKey("max_determinized_states");
            generator.write(this.maxDeterminizedStates);
        }
        if (this.rewrite != null) {
            generator.writeKey("rewrite");
            generator.write(this.rewrite);
        }
        generator.writeKey("value");
        generator.write(this.value);
        generator.writeEnd();
    }

    public Builder toBuilder() {
        return new Builder().field(this.field).value(this.value).caseInsensitive(this.caseInsensitive).flags(this.flags).maxDeterminizedStates(this.maxDeterminizedStates).rewrite(this.rewrite).value(this.value);
    }

    protected static void setupRegexpQueryDeserializer(ObjectDeserializer<Builder> op) {
        QueryBase.setupQueryBaseDeserializer(op);
        op.add(Builder::caseInsensitive, JsonpDeserializer.booleanDeserializer(), "case_insensitive");
        op.add(Builder::flags, JsonpDeserializer.stringDeserializer(), "flags");
        op.add(Builder::maxDeterminizedStates, JsonpDeserializer.integerDeserializer(), "max_determinized_states");
        op.add(Builder::rewrite, JsonpDeserializer.stringDeserializer(), "rewrite");
        op.add(Builder::value, JsonpDeserializer.stringDeserializer(), "value");
        op.setKey(Builder::field, JsonpDeserializer.stringDeserializer());
        op.shortcutProperty("value");
    }

    public static class Builder
    extends QueryBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RegexpQuery> {
        private String field;
        @Nullable
        private Boolean caseInsensitive;
        @Nullable
        private String flags;
        @Nullable
        private Integer maxDeterminizedStates;
        @Nullable
        private String rewrite;
        private String value;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder caseInsensitive(@Nullable Boolean value) {
            this.caseInsensitive = value;
            return this;
        }

        public final Builder flags(@Nullable String value) {
            this.flags = value;
            return this;
        }

        public final Builder maxDeterminizedStates(@Nullable Integer value) {
            this.maxDeterminizedStates = value;
            return this;
        }

        public final Builder rewrite(@Nullable String value) {
            this.rewrite = value;
            return this;
        }

        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RegexpQuery build() {
            this._checkSingleUse();
            return new RegexpQuery(this);
        }
    }
}

