/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.bulk;

import jakarta.json.stream.JsonGenerator;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.core.bulk.BulkOperationBase;

public abstract class WriteOperation
extends BulkOperationBase {
    @Nullable
    private final String pipeline;
    @Nullable
    private final Boolean requireAlias;

    protected WriteOperation(AbstractBuilder<?> builder) {
        super(builder);
        this.pipeline = ((AbstractBuilder)builder).pipeline;
        this.requireAlias = ((AbstractBuilder)builder).requireAlias;
    }

    @Nullable
    public final String pipeline() {
        return this.pipeline;
    }

    @Nullable
    public final Boolean requireAlias() {
        return this.requireAlias;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.pipeline != null) {
            generator.writeKey("pipeline");
            generator.write(this.pipeline);
        }
        if (this.requireAlias != null) {
            generator.writeKey("require_alias");
            generator.write(this.requireAlias);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupWriteOperationDeserializer(ObjectDeserializer<BuilderT> op) {
        BulkOperationBase.setupBulkOperationBaseDeserializer(op);
        op.add(AbstractBuilder::pipeline, JsonpDeserializer.stringDeserializer(), "pipeline");
        op.add(AbstractBuilder::requireAlias, JsonpDeserializer.booleanDeserializer(), "require_alias");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends BulkOperationBase.AbstractBuilder<BuilderT> {
        @Nullable
        private String pipeline;
        @Nullable
        private Boolean requireAlias;

        protected AbstractBuilder() {
        }

        public final BuilderT pipeline(@Nullable String value) {
            this.pipeline = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT requireAlias(@Nullable Boolean value) {
            this.requireAlias = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

