/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.generic;

import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.opensearch.generic.Body;

public final class Bodies {
    private static final String APPLICATION_JSON = "application/json; charset=UTF-8";

    private Bodies() {
    }

    public static <C> C json(Body body, JsonpDeserializer<C> deserializer, JsonpMapper jsonpMapper) {
        try (JsonParser parser = jsonpMapper.jsonProvider().createParser(body.body());){
            C c = deserializer.deserialize(parser, jsonpMapper);
            return c;
        }
    }

    public static <C> C json(Body body, Class<C> clazz, JsonpMapper jsonpMapper) {
        try (JsonParser parser = jsonpMapper.jsonProvider().createParser(body.body());){
            C c = jsonpMapper.deserialize(parser, clazz);
            return c;
        }
    }

    public static <C> Body json(C value, JsonpMapper jsonpMapper) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            try (JsonGenerator generator = jsonpMapper.jsonProvider().createGenerator(baos);){
                jsonpMapper.serialize(value, generator);
            }
            Body body = Body.from(baos.toByteArray(), APPLICATION_JSON);
            return body;
        }
    }

    public static Body json(JsonObjectBuilder builder) {
        return Bodies.json(builder.build());
    }

    public static Body json(JsonObject json) {
        return Bodies.json(json.toString());
    }

    public static Body json(String str) {
        return Body.from(str.getBytes(StandardCharsets.UTF_8), APPLICATION_JSON);
    }
}

