/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class AppendProcessor
extends ProcessorBase
implements ProcessorVariant {
    private final String field;
    private final List<JsonData> value;
    @Nullable
    private final Boolean allowDuplicates;
    public static final JsonpDeserializer<AppendProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AppendProcessor::setupAppendProcessorDeserializer);

    private AppendProcessor(Builder builder) {
        super(builder);
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.value = ApiTypeHelper.unmodifiableRequired(builder.value, (Object)this, "value");
        this.allowDuplicates = builder.allowDuplicates;
    }

    public static AppendProcessor of(Function<Builder, ObjectBuilder<AppendProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Append;
    }

    public final String field() {
        return this.field;
    }

    public final List<JsonData> value() {
        return this.value;
    }

    @Nullable
    public final Boolean allowDuplicates() {
        return this.allowDuplicates;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("field");
        generator.write(this.field);
        if (ApiTypeHelper.isDefined(this.value)) {
            generator.writeKey("value");
            generator.writeStartArray();
            for (JsonData item0 : this.value) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.allowDuplicates != null) {
            generator.writeKey("allow_duplicates");
            generator.write(this.allowDuplicates);
        }
    }

    protected static void setupAppendProcessorDeserializer(ObjectDeserializer<Builder> op) {
        AppendProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::value, JsonpDeserializer.arrayDeserializer(JsonData._DESERIALIZER), "value");
        op.add(Builder::allowDuplicates, JsonpDeserializer.booleanDeserializer(), "allow_duplicates");
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements ObjectBuilder<AppendProcessor> {
        private String field;
        private List<JsonData> value;
        @Nullable
        private Boolean allowDuplicates;

        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        public final Builder value(List<JsonData> list) {
            this.value = Builder._listAddAll(this.value, list);
            return this;
        }

        public final Builder value(JsonData value, JsonData ... values) {
            this.value = Builder._listAdd(this.value, value, values);
            return this;
        }

        public final Builder allowDuplicates(@Nullable Boolean value) {
            this.allowDuplicates = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AppendProcessor build() {
            this._checkSingleUse();
            return new AppendProcessor(this);
        }
    }
}

