/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;

@JsonpDeserializable
public class RepositorySettings
implements PlainJsonSerializable {
    @Nullable
    private final String chunkSize;
    @Nullable
    private final Boolean compress;
    @Nullable
    private final String concurrentStreams;
    private final String location;
    @Nullable
    private final Boolean readOnly;
    public static final JsonpDeserializer<RepositorySettings> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RepositorySettings::setupRepositorySettingsDeserializer);

    private RepositorySettings(Builder builder) {
        this.chunkSize = builder.chunkSize;
        this.compress = builder.compress;
        this.concurrentStreams = builder.concurrentStreams;
        this.location = ApiTypeHelper.requireNonNull(builder.location, this, "location");
        this.readOnly = builder.readOnly;
    }

    public static RepositorySettings of(Function<Builder, ObjectBuilder<RepositorySettings>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String chunkSize() {
        return this.chunkSize;
    }

    @Nullable
    public final Boolean compress() {
        return this.compress;
    }

    @Nullable
    public final String concurrentStreams() {
        return this.concurrentStreams;
    }

    public final String location() {
        return this.location;
    }

    @Nullable
    public final Boolean readOnly() {
        return this.readOnly;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.chunkSize != null) {
            generator.writeKey("chunk_size");
            generator.write(this.chunkSize);
        }
        if (this.compress != null) {
            generator.writeKey("compress");
            generator.write(this.compress);
        }
        if (this.concurrentStreams != null) {
            generator.writeKey("concurrent_streams");
            generator.write(this.concurrentStreams);
        }
        generator.writeKey("location");
        generator.write(this.location);
        if (this.readOnly != null) {
            generator.writeKey("read_only");
            generator.write(this.readOnly);
        }
    }

    protected static void setupRepositorySettingsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::chunkSize, JsonpDeserializer.stringDeserializer(), "chunk_size");
        op.add(Builder::compress, JsonpDeserializer.booleanDeserializer(), "compress");
        op.add(Builder::concurrentStreams, JsonpDeserializer.stringDeserializer(), "concurrent_streams");
        op.add(Builder::location, JsonpDeserializer.stringDeserializer(), "location");
        op.add(Builder::readOnly, JsonpDeserializer.booleanDeserializer(), "read_only", "readonly");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RepositorySettings> {
        @Nullable
        private String chunkSize;
        @Nullable
        private Boolean compress;
        @Nullable
        private String concurrentStreams;
        private String location;
        @Nullable
        private Boolean readOnly;

        public final Builder chunkSize(@Nullable String value) {
            this.chunkSize = value;
            return this;
        }

        public final Builder compress(@Nullable Boolean value) {
            this.compress = value;
            return this;
        }

        public final Builder concurrentStreams(@Nullable String value) {
            this.concurrentStreams = value;
            return this;
        }

        public final Builder location(String value) {
            this.location = value;
            return this;
        }

        public final Builder readOnly(@Nullable Boolean value) {
            this.readOnly = value;
            return this;
        }

        @Override
        public RepositorySettings build() {
            this._checkSingleUse();
            return new RepositorySettings(this);
        }
    }
}

