/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.transport.aws;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLHandshakeException;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jackson.JacksonJsonpMapper;
import org.opensearch.client.opensearch._types.ErrorCause;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch.generic.OpenSearchClientException;
import org.opensearch.client.transport.Endpoint;
import org.opensearch.client.transport.GenericEndpoint;
import org.opensearch.client.transport.JsonEndpoint;
import org.opensearch.client.transport.OpenSearchTransport;
import org.opensearch.client.transport.TransportException;
import org.opensearch.client.transport.TransportOptions;
import org.opensearch.client.transport.aws.AsyncByteArrayContentPublisher;
import org.opensearch.client.transport.aws.AsyncCapturingResponseHandler;
import org.opensearch.client.transport.aws.AwsSdk2TransportOptions;
import org.opensearch.client.transport.endpoints.BooleanEndpoint;
import org.opensearch.client.transport.endpoints.BooleanResponse;
import org.opensearch.client.util.MissingRequiredPropertyException;
import org.opensearch.client.util.OpenSearchRequestBodyBuffer;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.http.HttpExecuteResponse;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.SdkHttpResponse;
import software.amazon.awssdk.http.async.AsyncExecuteRequest;
import software.amazon.awssdk.http.async.SdkAsyncHttpClient;
import software.amazon.awssdk.http.async.SdkAsyncHttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpContentPublisher;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.SdkAutoCloseable;

public class AwsSdk2Transport
implements OpenSearchTransport {
    public static final Integer DEFAULT_REQUEST_COMPRESSION_SIZE = 8192;
    private static final byte[] NO_BYTES = new byte[0];
    private final SdkAutoCloseable httpClient;
    private final String host;
    private final String signingServiceName;
    private final Region signingRegion;
    private final JsonpMapper defaultMapper;
    private final AwsSdk2TransportOptions transportOptions;

    public AwsSdk2Transport(@CheckForNull SdkAsyncHttpClient asyncHttpClient, @Nonnull String host, @Nonnull Region signingRegion, @CheckForNull AwsSdk2TransportOptions options) {
        this(asyncHttpClient, host, "es", signingRegion, options);
    }

    public AwsSdk2Transport(@CheckForNull SdkHttpClient syncHttpClient, @Nonnull String host, @Nonnull Region signingRegion, @CheckForNull AwsSdk2TransportOptions options) {
        this(syncHttpClient, host, "es", signingRegion, options);
    }

    public AwsSdk2Transport(@CheckForNull SdkAsyncHttpClient asyncHttpClient, @Nonnull String host, @Nonnull String signingServiceName, @Nonnull Region signingRegion, @CheckForNull AwsSdk2TransportOptions options) {
        this((SdkAutoCloseable)asyncHttpClient, host, signingServiceName, signingRegion, options);
    }

    public AwsSdk2Transport(@CheckForNull SdkHttpClient syncHttpClient, @Nonnull String host, @Nonnull String signingServiceName, @Nonnull Region signingRegion, @CheckForNull AwsSdk2TransportOptions options) {
        this((SdkAutoCloseable)syncHttpClient, host, signingServiceName, signingRegion, options);
    }

    private AwsSdk2Transport(@CheckForNull SdkAutoCloseable httpClient, @Nonnull String host, @Nonnull String signingServiceName, @Nonnull Region signingRegion, @CheckForNull AwsSdk2TransportOptions options) {
        Objects.requireNonNull(host, "Target OpenSearch service host must not be null");
        this.httpClient = httpClient;
        this.host = host;
        this.signingServiceName = signingServiceName;
        this.signingRegion = signingRegion;
        this.transportOptions = options != null ? options : AwsSdk2TransportOptions.builder().build();
        this.defaultMapper = Optional.ofNullable(options).map(AwsSdk2TransportOptions::mapper).orElse(new JacksonJsonpMapper());
    }

    @Override
    public <RequestT, ResponseT, ErrorT> ResponseT performRequest(RequestT request, Endpoint<RequestT, ResponseT, ErrorT> endpoint, @Nullable TransportOptions options) throws IOException {
        OpenSearchRequestBodyBuffer requestBody = this.prepareRequestBody(request, endpoint, options);
        SdkHttpFullRequest clientReq = this.prepareRequest(request, endpoint, options, requestBody);
        if (this.httpClient instanceof SdkHttpClient) {
            return this.executeSync((SdkHttpClient)this.httpClient, clientReq, endpoint, options);
        }
        if (this.httpClient instanceof SdkAsyncHttpClient) {
            try {
                return this.executeAsync((SdkAsyncHttpClient)this.httpClient, clientReq, requestBody, endpoint, options).get();
            }
            catch (ExecutionException e) {
                Exception cause = AwsSdk2Transport.extractAndWrapCause(e);
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new IllegalStateException("unexpected exception type: must be either RuntimeException or IOException", cause);
            }
            catch (InterruptedException e) {
                throw new IOException("HttpRequest was interrupted", e);
            }
        }
        throw new IOException("invalid httpClient: " + this.httpClient);
    }

    @Override
    public <RequestT, ResponseT, ErrorT> CompletableFuture<ResponseT> performRequestAsync(RequestT request, Endpoint<RequestT, ResponseT, ErrorT> endpoint, @Nullable TransportOptions options) {
        try {
            OpenSearchRequestBodyBuffer requestBody = this.prepareRequestBody(request, endpoint, options);
            SdkHttpFullRequest clientReq = this.prepareRequest(request, endpoint, options, requestBody);
            if (this.httpClient instanceof SdkAsyncHttpClient) {
                return this.executeAsync((SdkAsyncHttpClient)this.httpClient, clientReq, requestBody, endpoint, options);
            }
            if (this.httpClient instanceof SdkHttpClient) {
                ResponseT result = this.executeSync((SdkHttpClient)this.httpClient, clientReq, endpoint, options);
                return CompletableFuture.completedFuture(result);
            }
            throw new IOException("invalid httpClient: " + this.httpClient);
        }
        catch (Throwable e) {
            CompletableFuture cf = new CompletableFuture();
            cf.completeExceptionally(e);
            return cf;
        }
    }

    @Override
    public JsonpMapper jsonpMapper() {
        return this.defaultMapper;
    }

    @Override
    public AwsSdk2TransportOptions options() {
        return this.transportOptions;
    }

    @Override
    public void close() {
    }

    @CheckForNull
    private <RequestT> OpenSearchRequestBodyBuffer prepareRequestBody(RequestT request, Endpoint<RequestT, ?, ?> endpoint, TransportOptions options) throws IOException {
        if (endpoint.hasRequestBody()) {
            JsonpMapper mapper = Optional.ofNullable(options).map(o -> o instanceof AwsSdk2TransportOptions ? (AwsSdk2TransportOptions)o : null).map(AwsSdk2TransportOptions::mapper).orElse(this.defaultMapper);
            int maxUncompressedSize = AwsSdk2Transport.or(Optional.ofNullable(options).map(o -> o instanceof AwsSdk2TransportOptions ? (AwsSdk2TransportOptions)o : null).map(AwsSdk2TransportOptions::requestCompressionSize), () -> Optional.ofNullable(this.transportOptions.requestCompressionSize())).orElse(DEFAULT_REQUEST_COMPRESSION_SIZE);
            OpenSearchRequestBodyBuffer buffer = new OpenSearchRequestBodyBuffer(mapper, maxUncompressedSize);
            buffer.addContent(request);
            buffer.close();
            return buffer;
        }
        return null;
    }

    private <RequestT> SdkHttpFullRequest prepareRequest(RequestT request, Endpoint<RequestT, ?, ?> endpoint, @CheckForNull TransportOptions options, @CheckForNull OpenSearchRequestBodyBuffer body) throws UnsupportedEncodingException {
        boolean responseCompression;
        SdkHttpFullRequest.Builder req = SdkHttpFullRequest.builder().method(SdkHttpMethod.fromValue((String)endpoint.method(request)));
        StringBuilder url = new StringBuilder();
        url.append("https://").append(this.host);
        String path = endpoint.requestUrl(request);
        if (!path.startsWith("/")) {
            url.append('/');
        }
        url.append(path);
        Map<String, String> params = endpoint.queryParameters(request);
        if (params != null && !params.isEmpty()) {
            int sep = 63;
            for (Map.Entry<String, String> ent : params.entrySet()) {
                url.append((char)sep).append(ent.getKey()).append('=');
                url.append(URLEncoder.encode(ent.getValue(), "UTF-8"));
                sep = 38;
            }
        }
        this.applyOptionsParams(url, this.transportOptions);
        this.applyOptionsParams(url, options);
        try {
            req.uri(new URI(url.toString()));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid request URI: " + url.toString());
        }
        this.applyOptionsHeaders(req, this.transportOptions);
        this.applyOptionsHeaders(req, options);
        if (endpoint.hasRequestBody() && body != null) {
            req.putHeader("Content-Type", body.getContentType());
            String encoding = body.getContentEncoding();
            if (encoding != null) {
                req.putHeader("Content-Encoding", encoding);
            }
            req.putHeader("Content-Length", String.valueOf(body.getContentLength()));
            req.contentStreamProvider(body::getInputStream);
            req.putHeader("x-amz-content-sha256", "required");
        }
        if (responseCompression = AwsSdk2Transport.or(Optional.ofNullable(options).map(o -> o instanceof AwsSdk2TransportOptions ? (AwsSdk2TransportOptions)o : null).map(AwsSdk2TransportOptions::responseCompression), () -> Optional.ofNullable(this.transportOptions.responseCompression())).orElse(Boolean.TRUE).booleanValue()) {
            req.putHeader("Accept-Encoding", "gzip");
        } else {
            req.removeHeader("Accept-Encoding");
        }
        AwsCredentialsProvider credentials = AwsSdk2Transport.or(Optional.ofNullable(options).map(o -> o instanceof AwsSdk2TransportOptions ? (AwsSdk2TransportOptions)o : null).map(AwsSdk2TransportOptions::credentials), () -> Optional.ofNullable(this.transportOptions.credentials())).orElse((AwsCredentialsProvider)DefaultCredentialsProvider.create());
        Aws4SignerParams signerParams = Aws4SignerParams.builder().awsCredentials(credentials.resolveCredentials()).signingName(this.signingServiceName).signingRegion(this.signingRegion).build();
        return Aws4Signer.create().sign(req.build(), signerParams);
    }

    private void applyOptionsParams(StringBuilder url, TransportOptions options) throws UnsupportedEncodingException {
        if (options == null) {
            return;
        }
        Map<String, String> params = options.queryParameters();
        if (params != null && !params.isEmpty()) {
            int sep = url.indexOf("?") < 0 ? 63 : 38;
            for (Map.Entry<String, String> param : params.entrySet()) {
                url.append((char)sep).append(param.getKey()).append('=');
                url.append(URLEncoder.encode(param.getValue(), "UTF-8"));
                sep = 63;
            }
        }
    }

    private void applyOptionsHeaders(SdkHttpFullRequest.Builder builder, TransportOptions options) {
        if (options == null) {
            return;
        }
        Collection<Map.Entry<String, String>> headers = options.headers();
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> header : headers) {
                builder.appendHeader(header.getKey(), header.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <ResponseT> ResponseT executeSync(SdkHttpClient syncHttpClient, SdkHttpFullRequest httpRequest, Endpoint<?, ResponseT, ?> endpoint, TransportOptions options) throws IOException {
        HttpExecuteRequest.Builder executeRequest = HttpExecuteRequest.builder().request((SdkHttpRequest)httpRequest);
        if (httpRequest.contentStreamProvider().isPresent()) {
            executeRequest.contentStreamProvider((ContentStreamProvider)httpRequest.contentStreamProvider().get());
        }
        HttpExecuteResponse executeResponse = syncHttpClient.prepareRequest(executeRequest.build()).call();
        try (AbortableInputStream bodyStream = null;){
            bodyStream = executeResponse.responseBody().orElse(null);
            SdkHttpResponse httpResponse = executeResponse.httpResponse();
            ResponseT ResponseT = this.parseResponse(httpRequest.getUri(), httpRequest.method(), httpRequest.protocol(), httpResponse, (InputStream)bodyStream, endpoint, options);
            return ResponseT;
        }
    }

    private <ResponseT> CompletableFuture<ResponseT> executeAsync(SdkAsyncHttpClient asyncHttpClient, SdkHttpFullRequest httpRequest, @CheckForNull OpenSearchRequestBodyBuffer requestBody, Endpoint<?, ResponseT, ?> endpoint, TransportOptions options) {
        byte[] requestBodyArray = requestBody == null ? NO_BYTES : requestBody.getByteArray();
        AsyncCapturingResponseHandler responseHandler = new AsyncCapturingResponseHandler();
        AsyncExecuteRequest.Builder executeRequest = AsyncExecuteRequest.builder().request((SdkHttpRequest)httpRequest).requestContentPublisher((SdkHttpContentPublisher)new AsyncByteArrayContentPublisher(requestBodyArray)).responseHandler((SdkAsyncHttpResponseHandler)responseHandler);
        CompletableFuture executeFuture = asyncHttpClient.execute(executeRequest.build());
        return ((CompletableFuture)executeFuture.thenCompose(_v -> responseHandler.getHeaderPromise())).thenCompose(response -> responseHandler.getBodyPromise().thenCompose(responseBody -> {
            CompletableFuture ret = new CompletableFuture();
            try {
                ByteArrayInputStream bodyStream = new ByteArrayInputStream((byte[])responseBody);
                ret.complete(this.parseResponse(httpRequest.getUri(), httpRequest.method(), httpRequest.protocol(), (SdkHttpResponse)response, bodyStream, endpoint, options));
            }
            catch (Throwable e) {
                ret.completeExceptionally(e);
            }
            return ret;
        }));
    }

    private <ResponseT, ErrorT> ResponseT parseResponse(URI uri, @Nonnull SdkHttpMethod method, String protocol, @Nonnull SdkHttpResponse httpResponse, @CheckForNull InputStream bodyStream, @Nonnull Endpoint<?, ResponseT, ErrorT> endpoint, @CheckForNull TransportOptions options) throws IOException {
        JsonpMapper mapper = Optional.ofNullable(options).map(o -> o instanceof AwsSdk2TransportOptions ? (AwsSdk2TransportOptions)o : null).map(AwsSdk2TransportOptions::mapper).orElse(this.defaultMapper);
        int statusCode = httpResponse.statusCode();
        boolean isZipped = httpResponse.firstMatchingHeader("Content-Encoding").map(enc -> enc.contains("gzip")).orElse(Boolean.FALSE);
        if (bodyStream != null && isZipped) {
            bodyStream = new GZIPInputStream(bodyStream);
        }
        if (statusCode == 403) {
            ErrorCause.Builder cause = new ErrorCause.Builder();
            cause.type("security_exception");
            cause.reason("authentication/authorization failure");
            if (bodyStream != null) {
                try (JsonParser parser2 = mapper.jsonProvider().createParser(bodyStream);){
                    JsonObject val = JsonpDeserializer.jsonValueDeserializer().deserialize(parser2, mapper).asJsonObject();
                    String message = null;
                    if (val.get("error") instanceof JsonObject) {
                        message = ((JsonValue)val.get("error")).asJsonObject().getString("reason", null);
                    }
                    if (message == null) {
                        message = val.getString("Message", null);
                    }
                    if (message == null) {
                        message = val.getString("message", null);
                    }
                    if (message != null) {
                        cause.reason(message);
                    }
                }
                catch (Exception parser2) {
                    // empty catch block
                }
            }
            ErrorResponse error = ErrorResponse.of(err -> err.status(statusCode).error(cause.build()));
            throw new OpenSearchException(error);
        }
        if (endpoint.isError(statusCode)) {
            if (endpoint instanceof GenericEndpoint) {
                GenericEndpoint rawEndpoint = (GenericEndpoint)endpoint;
                String contentType = null;
                if (bodyStream != null) {
                    contentType = httpResponse.firstMatchingHeader("Content-Type").orElse(null);
                }
                Object error = rawEndpoint.responseDeserializer(uri.toString(), method.name(), protocol, httpResponse.statusCode(), httpResponse.statusText().orElse(null), httpResponse.headers().entrySet().stream().map(h -> new AbstractMap.SimpleEntry<String, String>((String)h.getKey(), Objects.toString(h.getValue()))).collect(Collectors.toList()), contentType, bodyStream);
                throw rawEndpoint.exceptionConverter(statusCode, error);
            }
            JsonpDeserializer<ErrorT> errorDeserializer = endpoint.errorDeserializer(statusCode);
            if (errorDeserializer == null || bodyStream == null) {
                throw new TransportException("Request failed with status code '" + statusCode + "'");
            }
            bodyStream = AwsSdk2Transport.toByteArrayInputStream(bodyStream);
            try {
                try {
                    JsonParser parser = mapper.jsonProvider().createParser(bodyStream);
                    try {
                        ErrorT error = errorDeserializer.deserialize(parser, mapper);
                        throw new OpenSearchException((ErrorResponse)error);
                    }
                    catch (Throwable error) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable message) {
                                error.addSuppressed(message);
                            }
                        }
                        throw error;
                    }
                }
                catch (MissingRequiredPropertyException errorEx) {
                    bodyStream.reset();
                    return this.decodeResponse(uri, method, protocol, httpResponse, bodyStream, endpoint, mapper);
                }
            }
            catch (OpenSearchException e) {
                throw e;
            }
            catch (Exception e) {
                ErrorCause.Builder cause = new ErrorCause.Builder();
                cause.type("http_exception");
                cause.reason("server returned " + statusCode);
                ErrorResponse error = ErrorResponse.of(err -> err.status(statusCode).error(cause.build()));
                throw new OpenSearchException(error);
            }
        }
        return this.decodeResponse(uri, method, protocol, httpResponse, bodyStream, endpoint, mapper);
    }

    private <ResponseT, ErrorT> ResponseT decodeResponse(URI uri, @Nonnull SdkHttpMethod method, String protocol, @Nonnull SdkHttpResponse httpResponse, @CheckForNull InputStream bodyStream, @Nonnull Endpoint<?, ResponseT, ErrorT> endpoint, JsonpMapper mapper) throws IOException {
        if (endpoint instanceof BooleanEndpoint) {
            BooleanEndpoint bep = (BooleanEndpoint)endpoint;
            BooleanResponse response = new BooleanResponse(bep.getResult(httpResponse.statusCode()));
            return (ResponseT)response;
        }
        if (endpoint instanceof JsonEndpoint) {
            JsonEndpoint jsonEndpoint = (JsonEndpoint)endpoint;
            ResponseT response = null;
            JsonpDeserializer responseParser = jsonEndpoint.responseDeserializer();
            if (responseParser != null) {
                if (bodyStream == null) {
                    throw new TransportException("Expecting a response body, but none was sent");
                }
                try (JsonParser parser = mapper.jsonProvider().createParser(bodyStream);){
                    try {
                        response = responseParser.deserialize(parser, mapper);
                    }
                    catch (NullPointerException e) {
                        response = responseParser.deserialize(parser, mapper);
                    }
                }
            }
            return response;
        }
        if (endpoint instanceof GenericEndpoint) {
            GenericEndpoint rawEndpoint = (GenericEndpoint)endpoint;
            String contentType = null;
            if (bodyStream != null) {
                contentType = httpResponse.firstMatchingHeader("Content-Type").orElse(null);
            }
            return rawEndpoint.responseDeserializer(uri.toString(), method.name(), protocol, httpResponse.statusCode(), httpResponse.statusText().orElse(null), httpResponse.headers().entrySet().stream().map(h -> new AbstractMap.SimpleEntry<String, String>((String)h.getKey(), Objects.toString(h.getValue()))).collect(Collectors.toList()), contentType, bodyStream);
        }
        throw new TransportException("Unhandled endpoint type: '" + endpoint.getClass().getName() + "'");
    }

    private static <T> Optional<T> or(Optional<T> opt, Supplier<? extends Optional<? extends T>> supplier) {
        Objects.requireNonNull(opt);
        Objects.requireNonNull(supplier);
        if (opt.isPresent()) {
            return opt;
        }
        Optional<? extends T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    private static ByteArrayInputStream toByteArrayInputStream(InputStream is) throws IOException {
        if (is instanceof ByteArrayInputStream) {
            return (ByteArrayInputStream)is;
        }
        return new ByteArrayInputStream(IoUtils.toByteArray((InputStream)is));
    }

    private static Exception extractAndWrapCause(Exception exception) {
        Exception e;
        if (exception instanceof InterruptedException) {
            throw new RuntimeException("thread waiting for the response was interrupted", exception);
        }
        if (exception instanceof ExecutionException) {
            Throwable t;
            ExecutionException executionException = (ExecutionException)exception;
            Throwable throwable = t = executionException.getCause() == null ? executionException : executionException.getCause();
            if (t instanceof Error) {
                throw (Error)t;
            }
            exception = t;
        }
        if (exception instanceof SocketTimeoutException) {
            e = new SocketTimeoutException(exception.getMessage());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof SSLHandshakeException) {
            e = new SSLHandshakeException(exception.getMessage() + "\nSee https://opensearch.org/docs/latest/clients/java/ for troubleshooting.");
            e.initCause(exception);
            return e;
        }
        if (exception instanceof ConnectException) {
            e = new ConnectException(exception.getMessage());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof IOException) {
            return new IOException(exception.getMessage(), exception);
        }
        if (exception instanceof OpenSearchException) {
            e = new OpenSearchException(((OpenSearchException)exception).response());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof OpenSearchClientException) {
            e = new OpenSearchClientException(((OpenSearchClientException)exception).response());
            e.initCause(exception);
            return e;
        }
        if (exception instanceof RuntimeException) {
            return new RuntimeException(exception.getMessage(), exception);
        }
        return new RuntimeException("error while performing request", exception);
    }
}

