/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentelemetry;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Traceable;
import org.apache.camel.opentelemetry.OpenTelemetrySpanAdapter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCorrelationContextProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(GetCorrelationContextProcessor.class);
    private final String headerName;
    private final String keyName;
    private String id;
    private String routeId;

    public GetCorrelationContextProcessor(String keyName, String headerName) {
        this.keyName = ObjectHelper.notNull(keyName, "keyName");
        this.headerName = ObjectHelper.notNull(headerName, "headerName");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            OpenTelemetrySpanAdapter camelSpan = (OpenTelemetrySpanAdapter)ActiveSpanManager.getSpan(exchange);
            if (camelSpan != null) {
                String item = camelSpan.getContextPropagationItem(this.keyName);
                exchange.getMessage().setHeader(this.headerName, item);
            } else {
                LOG.warn("OpenTelemetry: Cannot find managed span for exchange: {}", (Object)exchange);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        finally {
            callback.done(true);
        }
        return true;
    }

    @Override
    public String getTraceLabel() {
        return "getCorrelationContext[" + this.keyName + ", " + this.headerName + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public String toString() {
        return this.id;
    }
}

