/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentelemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.opentelemetry.NoopTracingStrategy;
import org.apache.camel.opentelemetry.OpenTelemetrySpanAdapter;
import org.apache.camel.opentelemetry.OpenTelemetryTracingStrategy;
import org.apache.camel.opentelemetry.propagators.OpenTelemetryGetter;
import org.apache.camel.opentelemetry.propagators.OpenTelemetrySetter;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.tracing.ExtractAdapter;
import org.apache.camel.tracing.InjectAdapter;
import org.apache.camel.tracing.SpanAdapter;
import org.apache.camel.tracing.SpanDecorator;
import org.apache.camel.tracing.Tracer;
import org.apache.camel.tracing.decorators.AbstractInternalSpanDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JdkService(value="opentelemetry-tracer")
@Configurer
@ManagedResource(description="OpenTelemetryTracer")
public class OpenTelemetryTracer
extends Tracer {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTelemetryTracer.class);
    private io.opentelemetry.api.trace.Tracer tracer;
    private String instrumentationName = "camel";
    private ContextPropagators contextPropagators;
    private boolean traceProcessors;

    public io.opentelemetry.api.trace.Tracer getTracer() {
        return this.tracer;
    }

    public void setTracer(io.opentelemetry.api.trace.Tracer tracer) {
        this.tracer = tracer;
    }

    @ManagedAttribute(description="A name uniquely identifying the instrumentation scope, such as the instrumentation library, package, or fully qualified class name")
    public String getInstrumentationName() {
        return this.instrumentationName;
    }

    public void setInstrumentationName(String instrumentationName) {
        this.instrumentationName = instrumentationName;
    }

    @ManagedAttribute(description="Setting this to true will create new OpenTelemetry Spans for each Camel Processors")
    public boolean isTraceProcessors() {
        return this.traceProcessors;
    }

    public void setTraceProcessors(boolean traceProcessors) {
        this.traceProcessors = traceProcessors;
    }

    public ContextPropagators getContextPropagators() {
        return this.contextPropagators;
    }

    public void setContextPropagators(ContextPropagators contextPropagators) {
        this.contextPropagators = contextPropagators;
    }

    private SpanKind mapToSpanKind(org.apache.camel.tracing.SpanKind kind) {
        switch (kind) {
            case SPAN_KIND_CLIENT: {
                return SpanKind.CLIENT;
            }
            case SPAN_KIND_SERVER: {
                return SpanKind.SERVER;
            }
            case CONSUMER: {
                return SpanKind.CONSUMER;
            }
            case PRODUCER: {
                return SpanKind.PRODUCER;
            }
        }
        return SpanKind.SERVER;
    }

    @Override
    protected void initTracer() {
        if (this.tracer == null) {
            this.tracer = CamelContextHelper.findSingleByType(this.getCamelContext(), io.opentelemetry.api.trace.Tracer.class);
        }
        if (this.tracer == null) {
            this.tracer = GlobalOpenTelemetry.get().getTracer(this.instrumentationName);
        }
        if (this.traceProcessors && (this.getTracingStrategy() == null || this.getTracingStrategy().getClass().isAssignableFrom(NoopTracingStrategy.class))) {
            OpenTelemetryTracingStrategy tracingStrategy = new OpenTelemetryTracingStrategy(this);
            tracingStrategy.setPropagateContext(true);
            this.setTracingStrategy(tracingStrategy);
        }
    }

    @Override
    protected void initContextPropagators() {
        if (this.contextPropagators == null) {
            this.contextPropagators = CamelContextHelper.findSingleByType(this.getCamelContext(), ContextPropagators.class);
        }
        if (this.contextPropagators == null) {
            this.contextPropagators = GlobalOpenTelemetry.get().getPropagators();
        }
    }

    @Override
    protected SpanAdapter startSendingEventSpan(String operationName, org.apache.camel.tracing.SpanKind kind, SpanAdapter parent, Exchange exchange, InjectAdapter injectAdapter) {
        Baggage baggage = null;
        SpanBuilder builder = this.tracer.spanBuilder(operationName).setSpanKind(this.mapToSpanKind(kind));
        if (parent != null) {
            OpenTelemetrySpanAdapter oTelSpanWrapper = (OpenTelemetrySpanAdapter)parent;
            Span parentSpan = oTelSpanWrapper.getOpenTelemetrySpan();
            baggage = oTelSpanWrapper.getBaggage();
            builder = builder.setParent(Context.current().with(parentSpan));
        }
        return new OpenTelemetrySpanAdapter(builder.startSpan(), baggage);
    }

    @Override
    protected SpanAdapter startExchangeBeginSpan(Exchange exchange, SpanDecorator sd, String operationName, org.apache.camel.tracing.SpanKind kind, SpanAdapter parent) {
        Baggage baggage;
        SpanBuilder builder = this.tracer.spanBuilder(operationName);
        if (parent != null) {
            OpenTelemetrySpanAdapter spanFromExchange = (OpenTelemetrySpanAdapter)parent;
            builder = builder.setParent(Context.current().with(spanFromExchange.getOpenTelemetrySpan()));
            baggage = spanFromExchange.getBaggage();
        } else {
            ExtractAdapter adapter = sd.getExtractAdapter(exchange.getIn().getHeaders(), this.encoding);
            Context ctx = this.getContextPropagators().getTextMapPropagator().extract(Context.current(), adapter, new OpenTelemetryGetter(adapter));
            Span span = Span.fromContext(ctx);
            baggage = Baggage.fromContext(ctx);
            if (span != null && span.getSpanContext().isValid()) {
                builder.setParent(ctx).setSpanKind(this.mapToSpanKind(sd.getReceiverSpanKind()));
            } else if (!(sd instanceof AbstractInternalSpanDecorator)) {
                builder.setSpanKind(this.mapToSpanKind(sd.getReceiverSpanKind()));
            }
        }
        return new OpenTelemetrySpanAdapter(builder.startSpan(), baggage);
    }

    @Override
    protected void finishSpan(SpanAdapter span) {
        OpenTelemetrySpanAdapter openTracingSpanWrapper = (OpenTelemetrySpanAdapter)span;
        openTracingSpanWrapper.getOpenTelemetrySpan().end();
    }

    @Override
    protected void inject(SpanAdapter span, InjectAdapter adapter) {
        OpenTelemetrySpanAdapter spanFromExchange = (OpenTelemetrySpanAdapter)span;
        Span otelSpan = spanFromExchange.getOpenTelemetrySpan();
        Context ctx = Context.current().with(otelSpan);
        if (spanFromExchange.getBaggage() != null) {
            ctx = ctx.with(spanFromExchange.getBaggage());
        }
        this.getContextPropagators().getTextMapPropagator().inject(ctx, adapter, new OpenTelemetrySetter());
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        LOG.info("OpenTelemetryTracer enabled using instrumentation-name: {}", (Object)this.instrumentationName);
    }
}

