/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentelemetry;

import io.opentelemetry.api.trace.Span;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.opentelemetry.OpenTelemetrySpanAdapter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeProcessor.class);
    private final String attributeName;
    private final Expression expression;
    private String id;
    private String routeId;

    public AttributeProcessor(String tagName, Expression expression) {
        this.attributeName = ObjectHelper.notNull(tagName, "tagName");
        this.expression = ObjectHelper.notNull(expression, "expression");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            OpenTelemetrySpanAdapter camelSpan = (OpenTelemetrySpanAdapter)ActiveSpanManager.getSpan(exchange);
            Span span = camelSpan.getOpenTelemetrySpan();
            if (span != null) {
                String tag = this.expression.evaluate(exchange, String.class);
                span.setAttribute(this.attributeName, tag);
            } else {
                LOG.warn("OpenTelemetry: Cannot find managed span for exchange: {}", (Object)exchange);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        finally {
            callback.done(true);
        }
        return true;
    }

    @Override
    public String getTraceLabel() {
        return "attribute[" + this.attributeName + ", " + String.valueOf(this.expression) + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.id;
    }
}

