/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentelemetry;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.opentelemetry.OpenTelemetrySpanAdapter;
import org.apache.camel.spi.IdAware;
import org.apache.camel.spi.RouteIdAware;
import org.apache.camel.support.AsyncProcessorSupport;
import org.apache.camel.tracing.ActiveSpanManager;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetCorrelationContextProcessor
extends AsyncProcessorSupport
implements Traceable,
IdAware,
RouteIdAware {
    private static final Logger LOG = LoggerFactory.getLogger(SetCorrelationContextProcessor.class);
    private String id;
    private String routeId;
    private final String baggageName;
    private final Expression expression;

    public SetCorrelationContextProcessor(String baggageName, Expression expression) {
        this.baggageName = ObjectHelper.notNull(baggageName, "baggageName");
        this.expression = ObjectHelper.notNull(expression, "expression");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            OpenTelemetrySpanAdapter camelSpan = (OpenTelemetrySpanAdapter)ActiveSpanManager.getSpan(exchange);
            if (camelSpan != null) {
                String item = this.expression.evaluate(exchange, String.class);
                camelSpan.setCorrelationContextItem(this.baggageName, item);
            } else {
                LOG.debug("OpenTelemetry: Cannot find managed span for Exchange: {}", (Object)exchange);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        finally {
            callback.done(true);
        }
        return true;
    }

    @Override
    public String getTraceLabel() {
        return "setCorrelationContext[" + this.baggageName + ", " + String.valueOf(this.expression) + "]";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    public void setRouteId(String routeId) {
        this.routeId = routeId;
    }

    public String getBaggageName() {
        return this.baggageName;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public String toString() {
        return this.id;
    }
}

