/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.tracing;

import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.tracing.SpanAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class ActiveSpanManager {
    public static final String MDC_TRACE_ID = "trace_id";
    public static final String MDC_SPAN_ID = "span_id";
    private static final Logger LOG = LoggerFactory.getLogger(ActiveSpanManager.class);

    private ActiveSpanManager() {
    }

    public static SpanAdapter getSpan(Exchange exchange) {
        Holder holder = exchange.getProperty(ExchangePropertyKey.ACTIVE_SPAN, Holder.class);
        if (holder != null) {
            return holder.getSpan();
        }
        return null;
    }

    public static void activate(Exchange exchange, SpanAdapter span) {
        exchange.setProperty(ExchangePropertyKey.ACTIVE_SPAN, (Object)new Holder(exchange.getProperty(ExchangePropertyKey.ACTIVE_SPAN, Holder.class), span));
        if (Boolean.TRUE.equals(exchange.getContext().isUseMDCLogging())) {
            MDC.put((String)MDC_TRACE_ID, (String)span.traceId());
            MDC.put((String)MDC_SPAN_ID, (String)span.spanId());
        }
    }

    public static void deactivate(Exchange exchange) {
        Holder holder = exchange.getProperty(ExchangePropertyKey.ACTIVE_SPAN, Holder.class);
        if (holder != null) {
            Holder parent = holder.getParent();
            exchange.setProperty(ExchangePropertyKey.ACTIVE_SPAN, (Object)parent);
            holder.closeScope();
            if (Boolean.TRUE.equals(exchange.getContext().isUseMDCLogging())) {
                if (parent != null) {
                    SpanAdapter span = parent.getSpan();
                    MDC.put((String)MDC_TRACE_ID, (String)span.traceId());
                    MDC.put((String)MDC_SPAN_ID, (String)span.spanId());
                } else {
                    MDC.remove((String)MDC_TRACE_ID);
                    MDC.remove((String)MDC_SPAN_ID);
                }
            }
        }
    }

    public static void endScope(Exchange exchange) {
        Holder holder = exchange.getProperty(ExchangePropertyKey.ACTIVE_SPAN, Holder.class);
        if (holder != null) {
            holder.closeScope();
        }
    }

    public static class Holder {
        private final Holder parent;
        private final SpanAdapter span;
        private final AutoCloseable scope;

        Holder(Holder parent, SpanAdapter span) {
            this.parent = parent;
            this.span = span;
            this.scope = span.makeCurrent();
            if (LOG.isTraceEnabled()) {
                LOG.trace("Tracing: started scope: {}", (Object)this.scope);
            }
        }

        public Holder getParent() {
            return this.parent;
        }

        public SpanAdapter getSpan() {
            return this.span;
        }

        private void closeScope() {
            try {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Tracing: closing scope: {}", (Object)this.scope);
                }
                this.scope.close();
            }
            catch (Exception e) {
                LOG.debug("Failed to close span scope. This exception is ignored.", (Throwable)e);
            }
        }
    }
}

