/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho.mqtt5;

import java.util.Map;
import org.apache.camel.component.extension.ComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.DefaultComponentVerifierExtension;
import org.apache.camel.component.extension.verifier.ResultBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorBuilder;
import org.apache.camel.component.extension.verifier.ResultErrorHelper;
import org.apache.camel.component.paho.mqtt5.PahoMqtt5Endpoint;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.common.MqttException;

public class PahoMqtt5ComponentVerifierExtension
extends DefaultComponentVerifierExtension {
    public PahoMqtt5ComponentVerifierExtension() {
        this("paho-mqtt5");
    }

    public PahoMqtt5ComponentVerifierExtension(String scheme) {
        super(scheme);
    }

    @Override
    protected ComponentVerifierExtension.Result verifyParameters(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.PARAMETERS).error(ResultErrorHelper.requiresOption(parameters, "brokerUrl")).build();
    }

    @Override
    protected ComponentVerifierExtension.Result verifyConnectivity(Map<String, Object> parameters) {
        return ResultBuilder.withStatusAndScope(ComponentVerifierExtension.Result.Status.OK, ComponentVerifierExtension.Scope.CONNECTIVITY).error(parameters, this::verifyCredentials).build();
    }

    private void verifyCredentials(ResultBuilder builder, Map<String, Object> parameters) {
        block5: {
            String brokerUrl = (String)parameters.get("brokerUrl");
            String username = (String)parameters.get("userName");
            String password = (String)parameters.get("password");
            if (ObjectHelper.isNotEmpty(brokerUrl)) {
                try {
                    if (ObjectHelper.isEmpty(username) && ObjectHelper.isEmpty(password)) {
                        MqttClient client = new MqttClient(brokerUrl, PahoMqtt5Endpoint.generateClientId());
                        client.connect();
                        client.disconnect();
                        break block5;
                    }
                    MqttClient client = new MqttClient(brokerUrl, PahoMqtt5Endpoint.generateClientId());
                    MqttConnectionOptions connOpts = new MqttConnectionOptions();
                    connOpts.setUserName(username);
                    connOpts.setPassword(password.getBytes());
                    client.connect(connOpts);
                    client.disconnect();
                }
                catch (MqttException e) {
                    builder.error(ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_VALUE, "Unable to connect to MQTT broker").parameterKey("brokerUrl").build());
                }
            } else {
                builder.error(ResultErrorBuilder.withCodeAndDescription(ComponentVerifierExtension.VerificationError.StandardCode.ILLEGAL_PARAMETER_VALUE, "Invalid blank MQTT brokerUrl ").parameterKey("brokerUrl").build());
            }
        }
    }
}

